/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;

public class EntityScoreboardTags
implements Property {
    public static final String[] handledTags = new String[]{"scoreboard_tags"};
    public static final String[] handledMechs = new String[]{"scoreboard_tags", "clear_scoreboard_tags"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag;
    }

    public static EntityScoreboardTags getFrom(ObjectTag entity) {
        if (!EntityScoreboardTags.describes(entity)) {
            return null;
        }
        return new EntityScoreboardTags((EntityTag)entity);
    }

    public EntityScoreboardTags(EntityTag ent) {
        this.entity = ent;
    }

    public ListTag getTags() {
        return new ListTag(this.entity.getBukkitEntity().getScoreboardTags());
    }

    @Override
    public String getPropertyString() {
        ListTag tags = this.getTags();
        if (tags.isEmpty()) {
            return null;
        }
        return tags.identify();
    }

    @Override
    public String getPropertyId() {
        return "scoreboard_tags";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("scoreboard_tags")) {
            return this.getTags().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("clear_scoreboard_tags")) {
            for (String str : this.getTags()) {
                this.entity.getBukkitEntity().removeScoreboardTag(str);
            }
        }
        if (mechanism.matches("scoreboard_tags") && mechanism.hasValue()) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            for (String str : list) {
                this.entity.getBukkitEntity().addScoreboardTag(str);
            }
        }
    }
}

