/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgRaw;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugLog;
import java.io.File;
import java.io.FileWriter;
import java.net.URLDecoder;

public class LogCommand
extends AbstractCommand
implements Holdable {
    public LogCommand() {
        this.setName("log");
        this.setSyntax("log [<text>] (type:{info}/severe/warning/fine/finer/finest/none/clear) [file:<name>]");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgRaw @ArgLinear @ArgName(value="message") String message, @ArgPrefixed @ArgName(value="file") String fileName, @ArgPrefixed @ArgName(value="type") @ArgDefaultText(value="info") Type type) {
        if (!CoreConfiguration.allowLog) {
            Debug.echoError("Logging disabled by administrator (refer to command documentation).");
            scriptEntry.setFinished(true);
            return;
        }
        String directory = URLDecoder.decode(System.getProperty("user.dir"));
        File file = new File(directory, fileName);
        if (!DenizenCore.implementation.canWriteToFile(file)) {
            Debug.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
            scriptEntry.setFinished(true);
            return;
        }
        String output = message;
        Runnable run = () -> {
            try {
                file.getParentFile().mkdirs();
                if (type == Type.NONE) {
                    FileWriter fw = new FileWriter(file, true);
                    fw.write(output + "\n");
                    fw.close();
                    return;
                }
                if (type == Type.CLEAR) {
                    FileWriter fw = new FileWriter(file);
                    if (output.length() > 0) {
                        fw.write(output + "\n");
                    }
                    fw.close();
                    return;
                }
                DebugLog log = new DebugLog("Denizen-ScriptLog-" + fileName, file.getAbsolutePath());
                switch (type) {
                    case SEVERE: {
                        log.severe(output);
                        break;
                    }
                    case INFO: {
                        log.info(output);
                        break;
                    }
                    case WARNING: {
                        log.warning(output);
                        break;
                    }
                    case FINE: {
                        log.fine(output);
                        break;
                    }
                    case FINER: {
                        log.finer(output);
                        break;
                    }
                    case FINEST: {
                        log.finest(output);
                    }
                }
                log.close();
            }
            catch (Throwable ex) {
                DenizenCore.runOnMainThread(() -> {
                    Debug.echoError(scriptEntry, "Error logging to file...");
                    Debug.echoError(scriptEntry, ex);
                });
            }
            finally {
                scriptEntry.setFinished(true);
            }
        };
        if (scriptEntry.shouldWaitFor()) {
            DenizenCore.runAsync(run);
        } else {
            run.run();
        }
    }

    public static enum Type {
        SEVERE,
        INFO,
        WARNING,
        FINE,
        FINER,
        FINEST,
        NONE,
        CLEAR;

    }
}

