/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.abstracts;

import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.DoubleTag;
import com.denizenscript.denizen.nms.util.jnbt.FloatTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public abstract class ImprovedOfflinePlayer {
    public static Map<UUID, ImprovedOfflinePlayer> offlinePlayers = new HashMap<UUID, ImprovedOfflinePlayer>();
    public UUID player;
    public File file;
    public CompoundTag compound;
    public boolean exists;
    public PlayerInventory inventory;
    public Inventory enderchest;
    public boolean modified = false;
    public long timeLastLoaded = DenizenCore.currentTimeMonotonicMillis;

    public static void invalidateNow(UUID id) {
        ImprovedOfflinePlayer player = offlinePlayers.remove(id);
        if (player != null) {
            if (player.inventory != null) {
                player.setInventory(player.inventory);
            }
            if (player.enderchest != null) {
                player.setEnderChest(player.enderchest);
            }
            if (player.modified) {
                player.saveToFile();
            }
        }
    }

    public void markModified() {
        if (CoreConfiguration.debugVerbose) {
            Debug.verboseLog("[Verbose] player data modified for " + this.player + ", wasModified=" + this.modified + ", delay=" + Settings.worldPlayerDataSaveDelay);
        }
        if (Settings.worldPlayerDataSaveDelay <= 0.0f) {
            this.saveToFile();
            return;
        }
        if (!this.modified && Settings.worldPlayerDataSaveDelay < 86400.0f) {
            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                if (this.modified && offlinePlayers.get(this.player) == this) {
                    this.modified = false;
                    CompoundTag tag = this.compound;
                    if (CoreConfiguration.debugVerbose) {
                        Debug.verboseLog("[Verbose] async-saving player data for " + this.player);
                    }
                    DenizenCore.runAsync(() -> this.saveInternal(tag));
                }
            }, Settings.worldPlayerDataSaveDelay));
        }
        this.modified = true;
    }

    public ImprovedOfflinePlayer(UUID playeruuid) {
        this.exists = this.loadPlayerData(playeruuid);
    }

    public abstract PlayerInventory getInventory();

    public abstract void setInventory(PlayerInventory var1);

    public abstract Inventory getEnderChest();

    public abstract void setEnderChest(Inventory var1);

    public Location getLocation() {
        JNBTListTag position = this.compound.getListTag("Pos");
        JNBTListTag rotation = this.compound.getListTag("Rotation");
        return new Location(Bukkit.getWorld((UUID)new UUID(this.compound.getLong("WorldUUIDMost"), this.compound.getLong("WorldUUIDLeast"))), position.getDouble(0), position.getDouble(1), position.getDouble(2), rotation.getFloat(0), rotation.getFloat(1));
    }

    public void setLocation(Location location) {
        World w = location.getWorld();
        UUID uuid = w.getUID();
        ArrayList<DoubleTag> position = new ArrayList<DoubleTag>();
        position.add(new DoubleTag(location.getX()));
        position.add(new DoubleTag(location.getY()));
        position.add(new DoubleTag(location.getZ()));
        ArrayList<FloatTag> rotation = new ArrayList<FloatTag>();
        rotation.add(new FloatTag(location.getYaw()));
        rotation.add(new FloatTag(location.getPitch()));
        this.compound = this.compound.createBuilder().putLong("WorldUUIDMost", uuid.getMostSignificantBits()).putLong("WorldUUIDLeast", uuid.getLeastSignificantBits()).putInt("Dimension", w.getEnvironment().ordinal()).put("Pos", new JNBTListTag(DoubleTag.class, position)).put("Rotation", new JNBTListTag(FloatTag.class, rotation)).build();
        this.markModified();
    }

    public float getHealthFloat() {
        return this.compound.getFloat("Health");
    }

    public void setHealthFloat(float input) {
        this.compound = this.compound.createBuilder().putFloat("Health", input).build();
        this.markModified();
    }

    public abstract double getMaxHealth();

    public abstract void setMaxHealth(double var1);

    protected abstract boolean loadPlayerData(UUID var1);

    public void saveToFile() {
        if (this.exists && this.modified) {
            this.modified = false;
            this.saveInternal(this.compound);
        }
    }

    public abstract void saveInternal(CompoundTag var1);

    public boolean exists() {
        return this.exists;
    }

    public float getAbsorptionAmount() {
        return this.compound.getFloat("AbsorptionAmount");
    }

    public void setAbsorptionAmount(float input) {
        this.compound = this.compound.createBuilder().putFloat("AbsorptionAmount", input).build();
        this.markModified();
    }

    public Location getBedSpawnLocation() {
        return new Location(Bukkit.getWorld((String)this.compound.getString("SpawnWorld")), (double)this.compound.getInt("SpawnX"), (double)this.compound.getInt("SpawnY"), (double)this.compound.getInt("SpawnZ"));
    }

    public boolean isSpawnForced() {
        return this.compound.getBoolean("SpawnForced");
    }

    public void setBedSpawnLocation(Location location, boolean override) {
        this.compound = this.compound.createBuilder().putInt("SpawnX", (int)location.getX()).putInt("SpawnY", (int)location.getY()).putInt("SpawnZ", (int)location.getZ()).putString("SpawnWorld", location.getWorld().getName()).putBoolean("SpawnForced", override).build();
        this.markModified();
    }

    public float getExhaustion() {
        return this.compound.getFloat("foodExhaustionLevel");
    }

    public void setExhaustion(float input) {
        this.compound = this.compound.createBuilder().putFloat("foodExhaustionLevel", input).build();
        this.markModified();
    }

    public float getExp() {
        return this.compound.getFloat("XpP");
    }

    public void setExp(float input) {
        this.compound = this.compound.createBuilder().putFloat("XpP", input).build();
        this.markModified();
    }

    public float getFallDistance() {
        return this.compound.getFloat("FallDistance");
    }

    public void setFallDistance(float input) {
        this.compound = this.compound.createBuilder().putFloat("FallDistance", input).build();
        this.markModified();
    }

    public int getFireTicks() {
        return this.compound.getShort("Fire");
    }

    public void setFireTicks(int input) {
        this.compound = this.compound.createBuilder().putShort("Fire", (short)input).build();
        this.markModified();
    }

    public float getFlySpeed() {
        return ((CompoundTag)this.compound.getValue().get("abilities")).getFloat("flySpeed") * 2.0f;
    }

    public void setFlySpeed(float speed) {
        CompoundTag compoundTag = (CompoundTag)this.compound.getValue().get("abilities");
        compoundTag = compoundTag.createBuilder().putFloat("flySpeed", speed / 2.0f).build();
        this.compound = this.compound.createBuilder().put("abilities", compoundTag).build();
        this.markModified();
    }

    public int getFoodLevel() {
        return this.compound.getInt("foodLevel");
    }

    public void setFoodLevel(int input) {
        this.compound = this.compound.createBuilder().putInt("foodLevel", input).build();
        this.markModified();
    }

    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.compound.getInt("playerGameType"));
    }

    public void setGameMode(GameMode input) {
        this.compound = this.compound.createBuilder().putInt("playerGameType", input.getValue()).build();
        this.markModified();
    }

    public boolean getIsOnGround() {
        return this.compound.getBoolean("OnGround");
    }

    public void setIsOnGround(boolean input) {
        this.compound = this.compound.createBuilder().putBoolean("OnGround", input).build();
        this.markModified();
    }

    public int getItemInHand() {
        return this.compound.getInt("SelectedItemSlot");
    }

    public void setItemInHand(int input) {
        this.compound = this.compound.createBuilder().putInt("SelectedItemSlot", input).build();
        this.markModified();
    }

    public int getLevel() {
        return this.compound.getInt("XpLevel");
    }

    public void setLevel(int input) {
        this.compound = this.compound.createBuilder().putInt("XpLevel", input).build();
        this.markModified();
    }

    public UUID getUniqueId() {
        return this.player;
    }

    public int getRemainingAir() {
        return this.compound.getShort("Air");
    }

    public void setRemainingAir(int input) {
        this.compound = this.compound.createBuilder().putShort("Air", (short)input).build();
        this.markModified();
    }

    public float getSaturation() {
        return this.compound.getFloat("foodSaturationLevel");
    }

    public void setSaturation(float input) {
        this.compound = this.compound.createBuilder().putFloat("foodSaturationLevel", input).build();
        this.markModified();
    }

    public float getScore() {
        return this.compound.getFloat("foodSaturationLevel");
    }

    public void setScore(int input) {
        this.compound = this.compound.createBuilder().putInt("Score", input).build();
        this.markModified();
    }

    public short getTimeAttack() {
        return this.compound.getShort("AttackTime");
    }

    public void setTimeAttack(short input) {
        this.compound = this.compound.createBuilder().putShort("AttackTime", input).build();
        this.markModified();
    }

    public short getTimeDeath() {
        return this.compound.getShort("DeathTime");
    }

    public void setTimeDeath(short input) {
        this.compound = this.compound.createBuilder().putShort("DeathTime", input).build();
        this.markModified();
    }

    public short getTimeHurt() {
        return this.compound.getShort("HurtTime");
    }

    public void setTimeHurt(short input) {
        this.compound = this.compound.createBuilder().putShort("HurtTime", input).build();
        this.markModified();
    }

    public short getTimeSleep() {
        return this.compound.getShort("SleepTimer");
    }

    public void setTimeSleep(short input) {
        this.compound = this.compound.createBuilder().putShort("SleepTimer", input).build();
        this.markModified();
    }

    public int getTotalExperience() {
        return this.compound.getInt("XpTotal");
    }

    public void setTotalExperience(int input) {
        this.compound = this.compound.createBuilder().putInt("XpTotal", input).build();
        this.markModified();
    }

    public Vector getVelocity() {
        JNBTListTag list = this.compound.getListTag("Motion");
        return new Vector(list.getDouble(0), list.getDouble(1), list.getDouble(2));
    }

    public void setVelocity(Vector vector) {
        ArrayList<DoubleTag> motion = new ArrayList<DoubleTag>();
        motion.add(new DoubleTag(vector.getX()));
        motion.add(new DoubleTag(vector.getY()));
        motion.add(new DoubleTag(vector.getZ()));
        this.compound = this.compound.createBuilder().put("Motion", new JNBTListTag(DoubleTag.class, motion)).build();
        this.markModified();
    }

    public float getWalkSpeed() {
        return ((CompoundTag)this.compound.getValue().get("abilities")).getFloat("walkSpeed") * 2.0f;
    }

    public void setWalkSpeed(float speed) {
        CompoundTag compoundTag = (CompoundTag)this.compound.getValue().get("abilities");
        compoundTag = compoundTag.createBuilder().putFloat("walkSpeed", speed / 2.0f).build();
        this.compound = this.compound.createBuilder().put("abilities", compoundTag).build();
        this.markModified();
    }

    public boolean getAllowFlight() {
        return ((CompoundTag)this.compound.getValue().get("abilities")).getBoolean("mayfly");
    }

    public void setAllowFlight(boolean allow) {
        CompoundTag compoundTag = (CompoundTag)this.compound.getValue().get("abilities");
        compoundTag = compoundTag.createBuilder().putBoolean("mayfly", allow).build();
        this.compound = this.compound.createBuilder().put("abilities", compoundTag).build();
        this.markModified();
    }

    public void setLastDeathLocation(Location deathLoc) {
        CompoundTag compoundTag = (CompoundTag)this.compound.getValue().get("LastDeathLocation");
        compoundTag = compoundTag.createBuilder().putIntArray("pos", new int[]{deathLoc.getBlockX(), deathLoc.getBlockY(), deathLoc.getBlockZ()}).putString("dimension", deathLoc.getWorld().getKey().toString()).build();
        this.compound = this.compound.createBuilder().put("LastDeathLocation", compoundTag).build();
        this.markModified();
    }
}

