/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class InventoryScriptContainer
extends ScriptContainer {
    public boolean gui = CoreUtilities.equalsIgnoreCase(this.getString("gui", "false"), "true");

    public InventoryScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        InventoryScriptHelper.inventoryScripts.put(this.getName(), this);
    }

    public TagContext fixContext(TagContext context) {
        context = (context == null ? CoreUtilities.basicContext : context).clone();
        context.script = new ScriptTag(this);
        context.debug = context.debug && this.shouldDebug();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public InventoryTag getInventoryFrom(TagContext context) {
        InventoryTag inventory;
        block50: {
            context = this.fixContext(context);
            Debug.pushErrorContext(this);
            try {
                ListTag list;
                List<ScriptEntry> entries;
                boolean[] filledSlots;
                block49: {
                    String title;
                    InventoryType type = InventoryType.CHEST;
                    if (this.contains("inventory", String.class)) {
                        try {
                            type = InventoryType.valueOf((String)this.getString("inventory").toUpperCase());
                        }
                        catch (IllegalArgumentException ex) {
                            Debug.echoError(this, "Invalid inventory type specified. Assuming \"CHEST\" (" + ex.getMessage() + ")");
                        }
                    } else {
                        Debug.echoError(this, "Inventory script '" + this.getName() + "' does not specify an inventory type. Assuming \"CHEST\".");
                    }
                    if (type == InventoryType.PLAYER) {
                        Debug.echoError(this, "Inventory type 'player' is not valid for inventory scripts - defaulting to 'CHEST'.");
                        type = InventoryType.CHEST;
                    }
                    int size = 0;
                    if (this.contains("size", String.class)) {
                        if (type != InventoryType.CHEST) {
                            Debug.echoError(this, "You can only set the size of chest inventories!");
                        } else {
                            String sizeText = TagManager.tag(this.getString("size"), context);
                            if (!ArgumentHelper.matchesInteger(sizeText)) {
                                Debug.echoError(this, "Invalid (not-a-number) size value.");
                            } else {
                                size = Integer.parseInt(sizeText);
                            }
                            if (size == 0) {
                                Debug.echoError(this, "Inventory size can't be 0. Assuming default of inventory type...");
                            }
                            if (size % 9 != 0) {
                                size = (int)Math.ceil((double)size / 9.0) * 9;
                                Debug.echoError(this, "Inventory size must be a multiple of 9! Rounding up to " + size + "...");
                            }
                            if (size < 0) {
                                Debug.echoError(this, "Inventory size must be a positive number! Inverting to " + (size *= -1) + "...");
                            }
                        }
                    }
                    if (size == 0) {
                        size = this.contains("slots", List.class) && type == InventoryType.CHEST ? this.getStringList("slots").size() * 9 : type.getDefaultSize();
                    }
                    Debug.pushErrorContext("While reading 'title' input");
                    try {
                        title = this.contains("title", String.class) ? TagManager.tag(this.getString("title"), context) : null;
                    }
                    finally {
                        Debug.popErrorContext();
                    }
                    if (type == InventoryType.CHEST) {
                        inventory = new InventoryTag(size, title != null ? title : "Chest");
                    } else if (InventoryScriptHelper.isPersonalSpecialInv(type)) {
                        inventory = new InventoryTag(type);
                        inventory.customTitle = title;
                    } else {
                        inventory = title == null ? new InventoryTag(type) : new InventoryTag(type, title);
                    }
                    inventory.idType = "script";
                    inventory.idHolder = new ScriptTag(this);
                    filledSlots = new boolean[size];
                    Debug.pushErrorContext("While reading 'slots' input");
                    try {
                        if (!this.contains("slots", List.class)) break block49;
                        ItemStack[] finalItems = new ItemStack[size];
                        int itemsAdded = 0;
                        for (String string : this.getStringList("slots")) {
                            String[] itemsInLine;
                            String string2 = TagManager.tag(string, context).trim();
                            if (string2.isEmpty()) continue;
                            if (!string2.startsWith("[") || !string2.endsWith("]")) {
                                Debug.echoError(this, "Invalid slots line: [" + string2 + "]... Ignoring it");
                                continue;
                            }
                            for (String item : itemsInLine = string2.substring(1, string2.length() - 1).split("\\[?\\]?\\s+\\[", -1)) {
                                if (item.isEmpty()) {
                                    finalItems[itemsAdded++] = new ItemStack(Material.AIR);
                                    continue;
                                }
                                filledSlots[itemsAdded] = true;
                                if (this.contains("definitions." + item, String.class)) {
                                    ItemTag def = ItemTag.valueOf(TagManager.tag(this.getString("definitions." + item), context), context);
                                    if (def == null) {
                                        Debug.echoError(this, "Invalid definition '" + item + "'... Ignoring it and assuming 'AIR'");
                                        finalItems[itemsAdded] = new ItemStack(Material.AIR);
                                    } else {
                                        finalItems[itemsAdded] = def.getItemStack();
                                    }
                                } else {
                                    try {
                                        ItemTag itemTag = ItemTag.valueOf(item, context);
                                        if (itemTag == null) {
                                            finalItems[itemsAdded] = new ItemStack(Material.AIR);
                                            Debug.echoError(this, "Invalid slot item: [" + item + "]... ignoring it and assuming 'AIR'");
                                        } else {
                                            finalItems[itemsAdded] = itemTag.getItemStack();
                                        }
                                    }
                                    catch (Exception ex) {
                                        Debug.echoError(this, "Invalid slot item: [" + item + "]...");
                                        Debug.echoError(ex);
                                    }
                                }
                                ++itemsAdded;
                            }
                        }
                        inventory.setContents(finalItems);
                    }
                    finally {
                        Debug.popErrorContext();
                    }
                }
                if (!this.containsScriptSection("procedural items") || (entries = this.getEntries(context.getScriptEntryData(), "procedural items")).isEmpty()) break block50;
                InstantQueue queue = new InstantQueue(this.getName());
                queue.addEntries(entries);
                if (this.contains("definitions", Map.class)) {
                    for (Map.Entry entry : this.getConfigurationSection("definitions").getMap().entrySet()) {
                        ItemTag definitionValue = ItemTag.valueOf(TagManager.tag(entry.getValue().toString(), context), context);
                        if (definitionValue == null) {
                            Debug.echoError(this, "Invalid item '" + entry.getValue() + "' for definition '" + ((StringHolder)entry.getKey()).str + "'");
                            continue;
                        }
                        queue.addDefinition(((StringHolder)entry.getKey()).low, definitionValue);
                    }
                }
                queue.procedural = true;
                queue.start();
                if (queue.determinations == null || (list = ListTag.getListFor(queue.determinations.getObject(0), context)) == null) break block50;
                boolean bl = false;
                for (ItemTag item : list.filter(ItemTag.class, context, true)) {
                    void var10_19;
                    while (var10_19 < filledSlots.length && filledSlots[var10_19]) {
                        ++var10_19;
                    }
                    if (var10_19 >= filledSlots.length) break;
                    if (filledSlots[var10_19]) {
                        break;
                    }
                    inventory.setSlots((int)var10_19, item.getItemStack());
                    filledSlots[var10_19] = true;
                }
            }
            catch (Exception e) {
                Debug.echoError(this, "Woah! An exception has been called while building this inventory script!");
                Debug.echoError(e);
                inventory = null;
            }
            finally {
                Debug.popErrorContext();
            }
        }
        if (inventory != null) {
            InventoryTag.trackTemporaryInventory(inventory);
        }
        return inventory;
    }
}

