/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms;

import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.AnimationHelper;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.abstracts.ParticleHelper;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.interfaces.ChunkHelper;
import com.denizenscript.denizen.nms.interfaces.CustomEntityHelper;
import com.denizenscript.denizen.nms.interfaces.EnchantmentHelper;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.interfaces.WorldHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class NMSHandler {
    public static NMSHandler instance;
    private static NMSVersion version;
    private static JavaPlugin javaPlugin;
    public static boolean debugPackets;
    public static String debugPacketFilter;
    public static AdvancementHelper advancementHelper;
    public static AnimationHelper animationHelper;
    public static BlockHelper blockHelper;
    public static ChunkHelper chunkHelper;
    public static CustomEntityHelper customEntityHelper;
    public static EntityHelper entityHelper;
    public static FishingHelper fishingHelper;
    public static ItemHelper itemHelper;
    public static PacketHelper packetHelper;
    public static ParticleHelper particleHelper;
    public static PlayerHelper playerHelper;
    public static WorldHelper worldHelper;
    public static EnchantmentHelper enchantmentHelper;

    public static boolean initialize(JavaPlugin plugin) {
        javaPlugin = plugin;
        String bukkitVersion = Bukkit.getBukkitVersion();
        for (NMSVersion potentialVersion : NMSVersion.values()) {
            if (!bukkitVersion.startsWith(potentialVersion.minecraftVersion)) continue;
            version = potentialVersion;
            break;
        }
        if (version == null) {
            version = NMSVersion.NOT_SUPPORTED;
            instance = null;
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.denizenscript.denizen.nms." + version.name() + ".Handler");
            if (NMSHandler.class.isAssignableFrom(clazz)) {
                instance = (NMSHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        version = NMSVersion.NOT_SUPPORTED;
        instance = null;
        return false;
    }

    public static NMSHandler getInstance() {
        return instance;
    }

    public static NMSVersion getVersion() {
        return version;
    }

    public static JavaPlugin getJavaPlugin() {
        return javaPlugin;
    }

    public boolean isCorrectMappingsCode() {
        return true;
    }

    public abstract void disableAsyncCatcher();

    public abstract void undisableAsyncCatcher();

    public abstract Sidebar createSidebar(Player var1);

    public abstract BlockLight createBlockLight(Location var1, int var2, long var3);

    public abstract PlayerProfile fillPlayerProfile(PlayerProfile var1);

    public abstract PlayerProfile getPlayerProfile(Player var1);

    public abstract ProfileEditor getProfileEditor();

    public List<BiomeNMS> getBiomes(World world) {
        throw new UnsupportedOperationException();
    }

    public abstract BiomeNMS getBiomeNMS(World var1, String var2);

    public BiomeNMS getBiomeAt(Block block) {
        return instance.getBiomeNMS(block.getWorld(), block.getBiome().name());
    }

    public abstract double[] getRecentTps();

    public abstract CompoundTag createCompoundTag(Map<String, Tag> var1);

    public CompoundTag parseSNBT(String snbt) {
        throw new UnsupportedOperationException();
    }

    public abstract String getTitle(Inventory var1);

    public void setInventoryTitle(InventoryView view, String title) {
        throw new UnsupportedOperationException();
    }

    public abstract String stringForHover(HoverEvent var1);

    public abstract ArrayList<String> containerListFlags(PersistentDataContainer var1, String var2);

    public abstract boolean containerHas(PersistentDataContainer var1, String var2);

    public abstract String containerGetString(PersistentDataContainer var1, String var2);

    public UUID getBossbarUUID(BossBar bar) {
        return null;
    }

    public void setBossbarUUID(BossBar bar, UUID id) {
    }

    static {
        debugPackets = false;
        debugPacketFilter = "";
    }
}

