/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.DaylightDetector;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.block.data.type.EndPortalFrame;
import org.bukkit.block.data.type.Hopper;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.SculkShrieker;

public class MaterialSwitchable
implements Property {
    public static final String[] handledMechs = new String[]{"switched"};
    public MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof Powerable || data instanceof Openable || data instanceof Dispenser || data instanceof DaylightDetector || data instanceof Piston || data instanceof Lightable || data instanceof EndPortalFrame || data instanceof Hopper || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && data instanceof SculkShrieker;
    }

    public static MaterialSwitchable getFrom(ObjectTag _material) {
        if (!MaterialSwitchable.describes(_material)) {
            return null;
        }
        return new MaterialSwitchable((MaterialTag)_material);
    }

    public MaterialSwitchable(MaterialTag _material) {
        this.material = _material;
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialSwitchable.class, ElementTag.class, "switched", (attribute, material) -> new ElementTag(material.getState()), new String[0]);
    }

    public boolean isPowerable() {
        return this.material.getModernData() instanceof Powerable;
    }

    public boolean isOpenable() {
        return this.material.getModernData() instanceof Openable;
    }

    public boolean isDisepnser() {
        return this.material.getModernData() instanceof Dispenser;
    }

    public boolean isDaylightDetector() {
        return this.material.getModernData() instanceof DaylightDetector;
    }

    public boolean isLightable() {
        return this.material.getModernData() instanceof Lightable;
    }

    public boolean isPiston() {
        return this.material.getModernData() instanceof Piston;
    }

    public boolean isEndFrame() {
        return this.material.getModernData() instanceof EndPortalFrame;
    }

    public boolean isHopper() {
        return this.material.getModernData() instanceof Hopper;
    }

    public boolean isSculkShrieker() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && this.material.getModernData() instanceof SculkShrieker;
    }

    public Powerable getPowerable() {
        return (Powerable)this.material.getModernData();
    }

    public Openable getOpenable() {
        return (Openable)this.material.getModernData();
    }

    public Dispenser getDispenser() {
        return (Dispenser)this.material.getModernData();
    }

    public DaylightDetector getDaylightDetector() {
        return (DaylightDetector)this.material.getModernData();
    }

    public Piston getPiston() {
        return (Piston)this.material.getModernData();
    }

    public Lightable getLightable() {
        return (Lightable)this.material.getModernData();
    }

    public EndPortalFrame getEndFrame() {
        return (EndPortalFrame)this.material.getModernData();
    }

    public Hopper getHopper() {
        return (Hopper)this.material.getModernData();
    }

    public boolean getState() {
        if (this.isOpenable()) {
            return this.getOpenable().isOpen();
        }
        if (this.isLightable()) {
            return this.getLightable().isLit();
        }
        if (this.isPowerable()) {
            return this.getPowerable().isPowered();
        }
        if (this.isDisepnser()) {
            return this.getDispenser().isTriggered();
        }
        if (this.isDaylightDetector()) {
            return this.getDaylightDetector().isInverted();
        }
        if (this.isPiston()) {
            return this.getPiston().isExtended();
        }
        if (this.isEndFrame()) {
            return this.getEndFrame().hasEye();
        }
        if (this.isHopper()) {
            return this.getHopper().isEnabled();
        }
        if (this.isSculkShrieker()) {
            return ((SculkShrieker)this.material.getModernData()).isCanSummon();
        }
        return false;
    }

    public void setState(boolean state) {
        if (this.isOpenable()) {
            this.getOpenable().setOpen(state);
        } else if (this.isLightable()) {
            this.getLightable().setLit(state);
        } else if (this.isPowerable()) {
            this.getPowerable().setPowered(state);
        } else if (this.isDisepnser()) {
            this.getDispenser().setTriggered(state);
        } else if (this.isDaylightDetector()) {
            this.getDaylightDetector().setInverted(state);
        } else if (this.isPiston()) {
            this.getPiston().setExtended(state);
        } else if (this.isEndFrame()) {
            this.getEndFrame().setEye(state);
        } else if (this.isHopper()) {
            this.getHopper().setEnabled(state);
        } else if (this.isSculkShrieker()) {
            ((SculkShrieker)this.material.getModernData()).setCanSummon(state);
        }
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getState());
    }

    @Override
    public String getPropertyId() {
        return "switched";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("switched") && mechanism.requireBoolean()) {
            this.setState(mechanism.getValue().asBoolean());
        }
    }
}

