/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityResurrectEvent;

public class EntityResurrectScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public EntityResurrectEvent event;

    public EntityResurrectScriptEvent() {
        this.registerCouldMatcher("<entity> resurrected");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity;
            case "hand" -> {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    if (this.event.getHand() != null) {
                        yield new ElementTag((Enum<?>)this.event.getHand());
                    }
                    yield null;
                }
                yield null;
            }
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onEntityResurrect(EntityResurrectEvent event) {
        EntityTag.rememberEntity((Entity)event.getEntity());
        this.entity = new EntityTag((Entity)event.getEntity());
        this.event = event;
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)event.getEntity());
    }
}

