/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.utilities.Utilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.EntityType;

public class VanillaTagHelper {
    public static HashMap<Material, HashSet<String>> tagsByMaterial = new HashMap();
    public static HashMap<String, HashSet<Material>> materialTagsByKey = new HashMap();
    public static HashMap<EntityType, HashSet<String>> tagsByEntity = new HashMap();
    public static HashMap<String, HashSet<EntityType>> entityTagsByKey = new HashMap();

    public static void addOrUpdateMaterialTag(Tag<Material> tag) {
        if (materialTagsByKey.containsKey(tag.getKey().getKey())) {
            VanillaTagHelper.updateMaterialTag(tag);
        } else {
            VanillaTagHelper.addMaterialTag(tag);
        }
    }

    public static void addOrUpdateEntityTag(Tag<EntityType> tag) {
        if (entityTagsByKey.containsKey(tag.getKey().getKey())) {
            VanillaTagHelper.updateEntityTag(tag);
        } else {
            VanillaTagHelper.addEntityTag(tag);
        }
    }

    static <T extends Keyed> void update(Tag<T> tag, HashMap<T, HashSet<String>> tagByObj, HashMap<String, HashSet<T>> objByTag) {
        String tagName = Utilities.namespacedKeyToString(tag.getKey());
        Set objs = objByTag.get(tagName);
        if (objs == null) {
            return;
        }
        for (Keyed obj : objs) {
            Set tags = tagByObj.get(obj);
            if (tags.size() == 1) {
                tagByObj.remove(obj);
                continue;
            }
            tags.remove(tagName);
        }
        Set newObjs = tag.getValues();
        for (Keyed obj : newObjs) {
            tagByObj.computeIfAbsent(obj, k -> new HashSet()).add(tagName);
        }
        objs.clear();
        objs.addAll(newObjs);
    }

    public static void updateMaterialTag(Tag<Material> tag) {
        VanillaTagHelper.update(tag, tagsByMaterial, materialTagsByKey);
    }

    public static void updateEntityTag(Tag<EntityType> tag) {
        VanillaTagHelper.update(tag, tagsByEntity, entityTagsByKey);
    }

    static <T extends Keyed> void add(Tag<T> tag, HashMap<T, HashSet<String>> tagByObj, HashMap<String, HashSet<T>> objByTag) {
        String tagName = Utilities.namespacedKeyToString(tag.getKey());
        objByTag.computeIfAbsent(tagName, k -> new HashSet()).addAll(tag.getValues());
        for (Keyed obj : tag.getValues()) {
            tagByObj.computeIfAbsent(obj, k -> new HashSet()).add(tagName);
        }
    }

    static void addMaterialTag(Tag<Material> tag) {
        VanillaTagHelper.add(tag, tagsByMaterial, materialTagsByKey);
    }

    static void addEntityTag(Tag<EntityType> tag) {
        VanillaTagHelper.add(tag, tagsByEntity, entityTagsByKey);
    }

    public static void loadTagsCache() {
        tagsByMaterial.clear();
        materialTagsByKey.clear();
        tagsByEntity.clear();
        entityTagsByKey.clear();
        for (Tag tag : Bukkit.getTags((String)"blocks", Material.class)) {
            VanillaTagHelper.addMaterialTag((Tag<Material>)tag);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
            for (Tag tag : Bukkit.getTags((String)"entity_types", EntityType.class)) {
                VanillaTagHelper.addEntityTag((Tag<EntityType>)tag);
            }
        }
        for (Tag tag : Bukkit.getTags((String)"items", Material.class)) {
            VanillaTagHelper.addMaterialTag((Tag<Material>)tag);
        }
    }

    static {
        VanillaTagHelper.loadTagsCache();
    }
}

