/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;

public class FurnaceBurnsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ItemTag item;
    public LocationTag location;
    public FurnaceBurnEvent event;

    public FurnaceBurnsItemScriptEvent() {
        this.registerCouldMatcher("furnace burns <item>");
        this.registerOptionalDetermination(null, ObjectTag.class, (evt, context, time) -> {
            ElementTag elementTag;
            if (time instanceof ElementTag && (elementTag = (ElementTag)time).isInt()) {
                evt.event.setBurnTime(elementTag.asInt());
                return true;
            }
            if (time.canBeType(DurationTag.class)) {
                evt.event.setBurnTime(time.asType(DurationTag.class, context).getTicksAsInt());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(2, this.item)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "item" -> this.item;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onFurnaceBurns(FurnaceBurnEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.item = new ItemTag(event.getFuel());
        this.event = event;
        this.fire((Event)event);
    }
}

