/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.shaded.net.adventure.nbt.BinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.ByteArrayBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.ByteBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.CompoundBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.DoubleBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.EndBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.FloatBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.IntArrayBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.IntBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.ListBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.LongArrayBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.LongBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.ShortBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.StringBinaryTag;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTAdapter {
    public static final MethodHandle COMPOUND_TAG_MAP_CONSTRUCTOR = ReflectionHelper.getConstructor(NBTTagCompound.class, Map.class);

    public static NBTBase toNMS(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return switch (byteTag.value()) {
                case 0 -> NBTTagByte.b;
                case 1 -> NBTTagByte.c;
                default -> NBTTagByte.a((byte)byteTag.value());
            };
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return NBTTagShort.a((short)shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return NBTTagInt.a((int)intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return NBTTagLong.a((long)longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return NBTTagFloat.a((float)floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return NBTTagDouble.a((double)doubleTag.value());
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return new NBTTagByteArray(byteArrayTag.value());
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return new NBTTagIntArray(intArrayTag.value());
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return new NBTTagLongArray(longArrayTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return NBTTagString.a((String)stringTag.value());
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            return NBTAdapter.toNMS(listTag);
        }
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            return NBTAdapter.toNMS(compoundTag);
        }
        if (tag instanceof EndBinaryTag) {
            return NBTTagEnd.b;
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    public static BinaryTag toAPI(NBTBase nmsTag) {
        if (nmsTag instanceof NBTTagByte) {
            NBTTagByte nmsByteTag = (NBTTagByte)nmsTag;
            return ByteBinaryTag.byteBinaryTag(nmsByteTag.h());
        }
        if (nmsTag instanceof NBTTagShort) {
            NBTTagShort nmsShortTag = (NBTTagShort)nmsTag;
            return ShortBinaryTag.shortBinaryTag(nmsShortTag.g());
        }
        if (nmsTag instanceof NBTTagInt) {
            NBTTagInt nmsIntTag = (NBTTagInt)nmsTag;
            return IntBinaryTag.intBinaryTag(nmsIntTag.f());
        }
        if (nmsTag instanceof NBTTagLong) {
            NBTTagLong nmsLongTag = (NBTTagLong)nmsTag;
            return LongBinaryTag.longBinaryTag(nmsLongTag.e());
        }
        if (nmsTag instanceof NBTTagFloat) {
            NBTTagFloat nmsFloatTag = (NBTTagFloat)nmsTag;
            return FloatBinaryTag.floatBinaryTag(nmsFloatTag.j());
        }
        if (nmsTag instanceof NBTTagDouble) {
            NBTTagDouble nmsDoubleTag = (NBTTagDouble)nmsTag;
            return DoubleBinaryTag.doubleBinaryTag(nmsDoubleTag.i());
        }
        if (nmsTag instanceof NBTTagByteArray) {
            NBTTagByteArray nmsByteArrayTag = (NBTTagByteArray)nmsTag;
            return ByteArrayBinaryTag.byteArrayBinaryTag(nmsByteArrayTag.d());
        }
        if (nmsTag instanceof NBTTagIntArray) {
            NBTTagIntArray nmsIntArrayTag = (NBTTagIntArray)nmsTag;
            return IntArrayBinaryTag.intArrayBinaryTag(nmsIntArrayTag.f());
        }
        if (nmsTag instanceof NBTTagLongArray) {
            NBTTagLongArray nmsLongArrayTag = (NBTTagLongArray)nmsTag;
            return LongArrayBinaryTag.longArrayBinaryTag(nmsLongArrayTag.f());
        }
        if (nmsTag instanceof NBTTagString) {
            NBTTagString nmsStringTag = (NBTTagString)nmsTag;
            return StringBinaryTag.stringBinaryTag(nmsStringTag.e_());
        }
        if (nmsTag instanceof NBTTagList) {
            NBTTagList nmsListTag = (NBTTagList)nmsTag;
            return NBTAdapter.toAPI(nmsListTag);
        }
        if (nmsTag instanceof NBTTagCompound) {
            NBTTagCompound nmsCompoundTag = (NBTTagCompound)nmsTag;
            return NBTAdapter.toAPI(nmsCompoundTag);
        }
        if (nmsTag instanceof NBTTagEnd) {
            return EndBinaryTag.endBinaryTag();
        }
        throw new IllegalStateException("Unrecognized NMS tag of type '" + nmsTag.getClass().getName() + "/" + nmsTag.b().a() + "': " + String.valueOf(nmsTag));
    }

    public static ListBinaryTag toAPI(NBTTagList nmsListTag) {
        ListBinaryTag.Builder<BinaryTag> builder = ListBinaryTag.builder(nmsListTag.size());
        for (NBTBase nmsValue : nmsListTag) {
            builder.add(NBTAdapter.toAPI(nmsValue));
        }
        return builder.build();
    }

    public static NBTTagList toNMS(ListBinaryTag listTag) {
        NBTTagList nmsListTag = new NBTTagList();
        for (BinaryTag value : listTag) {
            nmsListTag.add((Object)NBTAdapter.toNMS(value));
        }
        return nmsListTag;
    }

    public static CompoundBinaryTag toAPI(NBTTagCompound nmsCompoundTag) {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder(nmsCompoundTag.e());
        for (String key : nmsCompoundTag.d()) {
            builder.put(key, NBTAdapter.toAPI(nmsCompoundTag.c(key)));
        }
        return builder.build();
    }

    public static NBTTagCompound toNMS(CompoundBinaryTag compoundTag) {
        HashMap<String, NBTBase> nmsTags = new HashMap<String, NBTBase>(compoundTag.size());
        for (Map.Entry entry : compoundTag) {
            nmsTags.put((String)entry.getKey(), NBTAdapter.toNMS((BinaryTag)entry.getValue()));
        }
        try {
            return COMPOUND_TAG_MAP_CONSTRUCTOR.invokeExact(nmsTags);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }
}

