/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class PistonRetractsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag material;
    public BlockPistonRetractEvent event;

    public PistonRetractsScriptEvent() {
        this.registerCouldMatcher("piston retracts");
        this.registerCouldMatcher("<block> retracts");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(0);
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!mat.equals("piston") && !this.material.tryAdvancedMatcher(mat, path.context)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "material" -> this.material;
            case "sticky" -> new ElementTag(this.event.isSticky());
            case "direction" -> new LocationTag(this.event.getDirection().getDirection());
            case "relative" -> new LocationTag(this.event.getBlock().getRelative(this.event.getDirection().getOppositeFace()).getLocation());
            case "blocks" -> new ListTag(this.event.getBlocks(), block -> new LocationTag(block.getLocation()));
            case "retract_location" -> new LocationTag(this.event.getBlock().getRelative(this.event.getDirection().getOppositeFace(), 2).getLocation());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPistonRetracts(BlockPistonRetractEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

