/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import net.citizensnpcs.api.scripting.RhinoScriptEngine;

public class RhinoScriptEngineFactory
implements ScriptEngineFactory {
    private final List<String> names = ImmutableList.of((Object)"rhino", (Object)"javascript", (Object)"JavaScript", (Object)"ECMAScript", (Object)"js");
    private final List<String> mimeTypes = ImmutableList.of((Object)"application/javascript", (Object)"text/javascript", (Object)"application/ecmascript", (Object)"text/javascript");
    private final List<String> extensions = ImmutableList.of((Object)"js", (Object)"ecmascript", (Object)"javascript");

    @Override
    public String getEngineName() {
        return "Mozilla Rhino (Citizens)";
    }

    @Override
    public String getEngineVersion() {
        return "version 1.7 release 3";
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getLanguageName() {
        return "ECMAScript";
    }

    @Override
    public String getLanguageVersion() {
        return "1.8";
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name") || key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        return obj + "." + m + "(" + Joiner.on((String)",").join((Object[])args) + ")";
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "print(\"" + toDisplay.replace("\"", "\\\"").replace("\\", "\\\\") + "\")";
    }

    @Override
    public String getProgram(String ... statements) {
        return Joiner.on((String)";").join((Object[])statements);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new RhinoScriptEngine().setScriptEngineFactory(this);
    }
}

