/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.ContextProvider;
import net.citizensnpcs.api.scripting.SimpleScriptFactory;

public class ScriptCompiler
implements Runnable {
    private final ScriptEngineManager engineManager = new ScriptEngineManager();
    private final Map<String, ScriptEngine> engines = Maps.newHashMap();
    private final Function<File, FileEngine> fileEngineConverter = new Function<File, FileEngine>(){

        public FileEngine apply(File file) {
            ScriptEngine engine;
            if (!file.isFile()) {
                return null;
            }
            String fileName = file.getName();
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (!ScriptCompiler.this.engines.containsKey(extension)) {
                ScriptEngine search = ScriptCompiler.this.engineManager.getEngineByExtension(extension);
                if (!(search == null || search instanceof Compilable && search instanceof Invocable)) {
                    search = null;
                }
                ScriptCompiler.this.engines.put(extension, search);
            }
            if ((engine = ScriptCompiler.this.engineManager.getEngineByExtension(extension)) == null) {
                return null;
            }
            return new FileEngine(file, engine);
        }
    };
    private final List<ContextProvider> globalContextProviders = Lists.newArrayList();
    private final BlockingQueue<CompileTask> toCompile = new LinkedBlockingQueue<CompileTask>();

    public CompileTaskBuilder compile(File ... files) {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("files should have a length of at least one");
        }
        Iterable toCompile = Iterables.transform((Iterable)Lists.newArrayList((Object[])files), this.fileEngineConverter);
        return new CompileTaskBuilder((FileEngine[])Iterables.toArray((Iterable)toCompile, FileEngine.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerGlobalContextProvider(ContextProvider provider) {
        List<ContextProvider> list = this.globalContextProviders;
        synchronized (list) {
            if (!this.globalContextProviders.contains(provider)) {
                this.globalContextProviders.add(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        try {
            CompileTask task = this.toCompile.take();
            for (FileEngine engine : task.files) {
                Compilable compiler = (Compilable)((Object)engine.engine);
                FileReader reader = null;
                try {
                    reader = new FileReader(engine.file);
                    CompiledScript src = compiler.compile(reader);
                    CompileCallback[] arr$2 = task.callbacks;
                    int len$2 = arr$2.length;
                    for (int i$2 = 0; i$2 < len$2; ++i$2) {
                        CompileCallback callback;
                        CompileCallback compileCallback = callback = arr$2[i$2];
                        synchronized (compileCallback) {
                            callback.onScriptCompiled(new SimpleScriptFactory(src, task.contextProviders));
                            continue;
                        }
                    }
                }
                catch (IOException ex) {
                    System.err.println("[Citizens]: IO fail while reading " + engine.file + " for scripting.");
                    ex.printStackTrace();
                    Closeables.closeQuietly((Closeable)reader);
                    continue;
                }
                catch (ScriptException e) {
                    System.err.println("[Citizens]: Compile error while parsing script at " + engine.file.getName() + ".");
                    e.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            Closeables.closeQuietly(reader);
                            throw throwable;
                        }
                    }
                    Closeables.closeQuietly((Closeable)reader);
                    continue;
                }
                Closeables.closeQuietly((Closeable)reader);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class FileEngine {
        ScriptEngine engine;
        File file;

        FileEngine(File file, ScriptEngine engine) {
            this.file = file;
            this.engine = engine;
        }
    }

    public class CompileTaskBuilder {
        private final List<CompileCallback> callbacks = Lists.newArrayList();
        private final List<ContextProvider> contextProviders = Lists.newArrayList();
        private final FileEngine[] files;

        private CompileTaskBuilder(FileEngine[] files) {
            this.files = files;
        }

        public boolean begin() {
            return ScriptCompiler.this.toCompile.offer(new CompileTask(this));
        }

        public CompileTaskBuilder withCallback(CompileCallback callback) {
            this.callbacks.add(callback);
            return this;
        }

        public CompileTaskBuilder withContextProvider(ContextProvider provider) {
            this.contextProviders.add(provider);
            return this;
        }
    }

    private class CompileTask {
        private final CompileCallback[] callbacks;
        private final ContextProvider[] contextProviders;
        private final FileEngine[] files;

        public CompileTask(CompileTaskBuilder builder) {
            ArrayList copy = Lists.newArrayList((Iterable)builder.contextProviders);
            copy.addAll(ScriptCompiler.this.globalContextProviders);
            this.contextProviders = copy.toArray(new ContextProvider[0]);
            this.files = builder.files;
            this.callbacks = builder.callbacks.toArray(new CompileCallback[0]);
        }
    }
}

