/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.GoalSelector;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public class SimpleGoalController
implements GoalController {
    private final List<Goal> executingGoals = Lists.newArrayList();
    private int executingPriority = -1;
    private Goal executingRootGoal;
    private final List<SimpleGoalEntry> possibleGoals = Lists.newArrayList();
    private final GoalSelector selector = new SimpleGoalSelector();
    private final List<Goal> toRemove = Lists.newArrayList();

    @Override
    public void addGoal(Goal goal, int priority) {
        Preconditions.checkNotNull((Object)goal, (Object)"goal cannot be null");
        Preconditions.checkState((priority > 0 && priority < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"priority must be greater than 0");
        SimpleGoalEntry entry = new SimpleGoalEntry(goal, priority);
        if (this.possibleGoals.contains(entry)) {
            return;
        }
        this.possibleGoals.add(entry);
        Collections.sort(this.possibleGoals);
    }

    private void addGoalToExecution(Goal goal) {
        Bukkit.getPluginManager().registerEvents((Listener)goal, CitizensAPI.getPlugin());
        this.executingGoals.add(goal);
    }

    private void finishCurrentGoalExecution() {
        this.resetGoalList();
        this.executingPriority = -1;
        this.executingRootGoal = null;
    }

    @Override
    public void removeGoal(Goal goal) {
        Preconditions.checkNotNull((Object)goal, (Object)"goal cannot be null");
        this.toRemove.add(goal);
    }

    private void removePendingGoals() {
        for (int i = 0; i < this.toRemove.size(); ++i) {
            Goal remove = this.toRemove.remove(i--);
            for (int j = 0; j < this.possibleGoals.size(); ++j) {
                Goal test = this.possibleGoals.get((int)j).goal;
                if (!test.equals(remove)) continue;
                this.possibleGoals.remove(j--);
                if (test != this.executingRootGoal) continue;
                this.finishCurrentGoalExecution();
            }
        }
    }

    private void resetGoalList() {
        for (int i = 0; i < this.executingGoals.size(); ++i) {
            Goal goal = this.executingGoals.remove(i--);
            goal.reset();
            HandlerList.unregisterAll((Listener)goal);
        }
    }

    @Override
    public void run() {
        if (this.possibleGoals.isEmpty()) {
            return;
        }
        this.removePendingGoals();
        this.trySelectGoal();
        for (int i = 0; i < this.executingGoals.size(); ++i) {
            this.executingGoals.get(i).run();
        }
    }

    private void setupExecution(SimpleGoalEntry entry) {
        this.finishCurrentGoalExecution();
        this.executingPriority = entry.priority;
        this.executingRootGoal = entry.goal;
        this.addGoalToExecution(entry.goal);
    }

    private void trySelectGoal() {
        int searchPriority = Math.min(this.executingPriority, 1);
        for (int i = this.possibleGoals.size() - 1; i >= 0; --i) {
            SimpleGoalEntry entry = this.possibleGoals.get(i);
            if (searchPriority > entry.priority) {
                return;
            }
            if (entry.goal == this.executingRootGoal || !entry.goal.shouldExecute(this.selector)) continue;
            this.setupExecution(entry);
            return;
        }
    }

    @Override
    public Iterator<GoalController.GoalEntry> iterator() {
        final Iterator<SimpleGoalEntry> itr = this.possibleGoals.iterator();
        return new Iterator<GoalController.GoalEntry>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public GoalController.GoalEntry next() {
                return (GoalController.GoalEntry)itr.next();
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    public class SimpleGoalSelector
    implements GoalSelector {
        @Override
        public void finish() {
            SimpleGoalController.this.finishCurrentGoalExecution();
        }

        @Override
        public void finishAndRemove() {
            Goal toRemove = SimpleGoalController.this.executingRootGoal;
            this.finish();
            if (toRemove != null) {
                SimpleGoalController.this.removeGoal(toRemove);
            }
        }

        @Override
        public void select(Goal goal) {
            SimpleGoalController.this.resetGoalList();
            SimpleGoalController.this.addGoalToExecution(goal);
        }

        @Override
        public void selectAdditional(Goal ... goals) {
            for (Goal goal : goals) {
                SimpleGoalController.this.addGoalToExecution(goal);
            }
        }
    }

    private static class SimpleGoalEntry
    implements GoalController.GoalEntry {
        final Goal goal;
        final int priority;

        private SimpleGoalEntry(Goal goal, int priority) {
            this.goal = goal;
            this.priority = priority;
        }

        @Override
        public int compareTo(GoalController.GoalEntry o) {
            return o.getPriority() > this.priority ? 1 : (o.getPriority() < this.priority ? -1 : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleGoalEntry other = (SimpleGoalEntry)obj;
            if (this.goal == null ? other.goal != null : !this.goal.equals(other.goal)) {
                return false;
            }
            return this.priority == other.priority;
        }

        public int hashCode() {
            int prime = 31;
            return 31 * (31 + (this.goal == null ? 0 : this.goal.hashCode())) + this.priority;
        }

        @Override
        public Goal getGoal() {
            return this.goal;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }
}

