/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMSReflection;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityCaveSpider;
import net.minecraft.server.World;
import org.bukkit.entity.CaveSpider;
import org.bukkit.util.Vector;

public class CitizensCaveSpiderNPC
extends CitizensMobNPC {
    public CitizensCaveSpiderNPC(int id, String name) {
        super(id, name, EntityCaveSpiderNPC.class);
    }

    public CaveSpider getBukkitEntity() {
        return (CaveSpider)this.getHandle().getBukkitEntity();
    }

    public static class EntityCaveSpiderNPC
    extends EntityCaveSpider
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityCaveSpiderNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMSReflection.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void bc() {
            super.bc();
            this.npc.update();
        }

        public void be() {
            if (this.npc == null) {
                super.be();
            } else {
                this.npc.update();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            Util.callCollisionEvent(this.npc, entity);
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

