/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import java.util.Iterator;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;

public class WaypointGoal
implements Goal {
    private Location currentDestination;
    private Iterator<Location> itr;
    private final Navigator navigator;
    private boolean paused;
    private final Iterable<Location> provider;
    private GoalSelector selector;

    public WaypointGoal(Iterable<Location> provider, Navigator navigator) {
        this.provider = provider;
        this.navigator = navigator;
    }

    private void ensureItr() {
        if (this.itr == null || !this.itr.hasNext()) {
            this.itr = this.provider.iterator();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    @EventHandler
    public void onNavigationCancel(NavigationCancelEvent event) {
        if (this.currentDestination == null || !event.getNavigator().equals(this.navigator)) {
            return;
        }
        if (this.currentDestination.equals((Object)event.getNavigator().getTargetAsLocation())) {
            this.selector.finish();
        }
    }

    @EventHandler
    public void onNavigationComplete(NavigationCompleteEvent event) {
        if (this.currentDestination == null || !event.getNavigator().equals(this.navigator)) {
            return;
        }
        if (this.currentDestination.equals((Object)event.getNavigator().getTargetAsLocation())) {
            this.selector.finish();
        }
    }

    public void onProviderChanged() {
        this.itr = this.provider.iterator();
        if (this.currentDestination != null) {
            this.selector.finish();
        }
    }

    @Override
    public void reset() {
        this.currentDestination = null;
        this.selector = null;
    }

    @Override
    public void run() {
    }

    public void setPaused(boolean paused) {
        if (paused && this.currentDestination != null) {
            this.selector.finish();
        }
        this.paused = paused;
    }

    @Override
    public boolean shouldExecute(GoalSelector selector) {
        if (this.paused || this.currentDestination != null) {
            return false;
        }
        this.ensureItr();
        boolean shouldExecute = this.itr.hasNext();
        if (shouldExecute) {
            this.selector = selector;
            this.currentDestination = this.itr.next();
            this.navigator.setTarget(this.currentDestination);
        }
        return shouldExecute;
    }
}

