/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import net.krinsoft.privileges.Privileges;
import net.krinsoft.privileges.groups.Group;
import net.krinsoft.privileges.groups.GroupManager;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Permission_Privileges
extends Permission {
    private final String name = "";
    private GroupManager perms;
    private Privileges privs;

    public Permission_Privileges(Plugin plugin) {
        Plugin perms;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), plugin);
        if (this.perms == null && (perms = plugin.getServer().getPluginManager().getPlugin("Privileges")) != null && perms.isEnabled()) {
            this.privs = (Privileges)perms;
            this.perms = this.privs.getGroupManager();
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), ""));
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean playerHas(String world, String player, String permission) {
        Player p = this.plugin.getServer().getPlayer(player);
        return p != null ? p.hasPermission(permission) : false;
    }

    @Override
    public boolean playerAdd(String world, String player, String permission) {
        return false;
    }

    @Override
    public boolean playerRemove(String world, String player, String permission) {
        return false;
    }

    @Override
    public boolean groupHas(String world, String group, String permission) {
        ConfigurationSection priv = this.privs.getGroupNode(group);
        if (priv == null) {
            return false;
        }
        return priv.getBoolean(permission);
    }

    @Override
    public boolean groupAdd(String world, String group, String permission) {
        throw new UnsupportedOperationException("Privileges does not support modifying permissions.");
    }

    @Override
    public boolean groupRemove(String world, String group, String permission) {
        throw new UnsupportedOperationException("Privileges does not support modifying permissions.");
    }

    @Override
    public boolean playerInGroup(String world, String player, String group) {
        Player p = Bukkit.getPlayer((String)player);
        if (p == null) {
            throw new UnsupportedOperationException("Privileges does not support offline players.");
        }
        Group g = this.perms.getGroup(p);
        return g != null && g.getName().equalsIgnoreCase(group);
    }

    @Override
    public boolean playerAddGroup(String world, String player, String group) {
        if (world != null) {
            return false;
        }
        this.perms.setGroup(player, group);
        return true;
    }

    @Override
    public boolean playerRemoveGroup(String world, String player, String group) {
        Group g = this.perms.getDefaultGroup();
        if (g == null) {
            return false;
        }
        return this.playerAddGroup(world, player, g.getName());
    }

    @Override
    public String[] getPlayerGroups(String world, String player) {
        String[] stringArray;
        Player p = Bukkit.getPlayer((String)player);
        if (p == null) {
            throw new UnsupportedOperationException("Privileges does not support offline players.");
        }
        Group g = this.perms.getGroup(p);
        if (g != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = g.getName();
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @Override
    public String getPrimaryGroup(String world, String player) {
        Player p = Bukkit.getPlayer((String)player);
        if (p == null) {
            throw new UnsupportedOperationException("Privileges does not support offline players.");
        }
        Group g = this.perms.getGroup(p);
        return g != null ? g.getName() : null;
    }

    @Override
    public String[] getGroups() {
        FileConfiguration file = this.privs.getGroups();
        ConfigurationSection groups = file.getConfigurationSection("groups");
        return groups != null ? groups.getKeys(false).toArray(new String[0]) : null;
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    public class PermissionServerListener
    implements Listener {
        Permission_Privileges permission = null;

        public PermissionServerListener(Permission_Privileges permission) {
            this.permission = permission;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin perms;
            if (this.permission.perms == null && (perms = Permission_Privileges.this.plugin.getServer().getPluginManager().getPlugin("SimplyPerms")) != null && perms.isEnabled()) {
                this.permission.privs = (Privileges)perms;
                this.permission.perms = this.permission.privs.getGroupManager();
                log.info(String.format("[%s][Permission] %s hooked.", Permission_Privileges.this.plugin.getDescription().getName(), ""));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.permission.perms != null && event.getPlugin().getDescription().getName().equals("SimplyPerms")) {
                this.permission.perms = null;
                this.permission.privs = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_Privileges.this.plugin.getDescription().getName(), ""));
            }
        }
    }
}

