/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationReplaceEvent;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.util.NMSReflection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class CitizensNavigator
implements Navigator {
    private PathStrategy executing;
    private final CitizensNPC npc;
    private float pathfindingRange = Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat();
    private float speed = -1.0f;

    public CitizensNavigator(CitizensNPC npc) {
        this.npc = npc;
    }

    @Override
    public void cancelNavigation() {
        if (this.executing != null) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationCancelEvent(this));
        }
        this.executing = null;
    }

    @Override
    public EntityTarget getEntityTarget() {
        return this.executing instanceof EntityTarget ? (EntityTarget)((Object)this.executing) : null;
    }

    @Override
    public float getPathfindingRange() {
        return this.pathfindingRange;
    }

    @Override
    public float getSpeed() {
        if (this.speed == -1.0f) {
            throw new IllegalStateException("NPC has not been spawned");
        }
        return this.speed;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.isNavigating() ? this.executing.getTargetAsLocation() : null;
    }

    @Override
    public TargetType getTargetType() {
        return this.isNavigating() ? this.executing.getTargetType() : null;
    }

    @Override
    public boolean isNavigating() {
        return this.executing != null;
    }

    public void load(DataKey root) {
        this.speed = (float)root.getDouble("speed", this.speed);
        this.pathfindingRange = (float)root.getDouble("pathfinding-range", this.pathfindingRange);
    }

    public void onSpawn() {
        if (this.speed == -1.0f) {
            this.speed = NMSReflection.getSpeedFor(this.npc.getHandle());
        }
        this.updatePathfindingRange();
    }

    public void save(DataKey root) {
        root.setDouble("speed", this.speed);
        root.setDouble("pathfinding-range", this.pathfindingRange);
    }

    @Override
    public void setPathfindingRange(float newRange) {
        this.pathfindingRange = newRange;
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
        if (this.isNavigating()) {
            this.executing.setSpeed(this.speed);
        }
    }

    @Override
    public void setTarget(LivingEntity target, boolean aggressive) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        MCTargetStrategy newStrategy = new MCTargetStrategy(this.npc, target, aggressive, this.speed);
        this.switchStrategyTo(newStrategy);
    }

    @Override
    public void setTarget(Location target) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        MCNavigationStrategy newStrategy = new MCNavigationStrategy(this.npc, target, this.speed);
        this.switchStrategyTo(newStrategy);
    }

    private void switchStrategyTo(PathStrategy newStrategy) {
        if (this.executing != null) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationReplaceEvent(this));
        }
        this.executing = newStrategy;
        Bukkit.getPluginManager().callEvent((Event)new NavigationBeginEvent(this));
    }

    public void update() {
        if (this.executing == null || !this.npc.isSpawned()) {
            return;
        }
        boolean finished = this.executing.update();
        if (finished) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationCompleteEvent(this));
            this.executing = null;
        }
    }

    private void updatePathfindingRange() {
        NMSReflection.updatePathfindingRange(this.npc, this.pathfindingRange);
    }
}

