/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPigZombie;
import net.minecraft.server.World;
import org.bukkit.entity.PigZombie;
import org.bukkit.util.Vector;

public class CitizensPigZombieNPC
extends CitizensMobNPC {
    public CitizensPigZombieNPC(int id, String name) {
        super(id, name, EntityPigZombieNPC.class);
    }

    public PigZombie getBukkitEntity() {
        return (PigZombie)super.getBukkitEntity();
    }

    public static class EntityPigZombieNPC
    extends EntityPigZombie
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityPigZombieNPC(World world) {
            this(world, null);
        }

        public EntityPigZombieNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void bb() {
            if (this.npc == null) {
                super.bb();
            }
        }

        public void bc() {
            super.bc();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void be() {
            if (this.npc == null) {
                super.be();
            } else {
                NMS.updateAI((EntityLiving)this);
                this.npc.update();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            Util.callCollisionEvent((NPC)this.npc, entity);
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent((NPC)this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

