/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.collect.Lists;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.NPCSelectEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class NPCSelector
implements Listener {
    private int consoleSelectedNPC = -1;
    private final Plugin plugin;

    public NPCSelector(Plugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public NPC getSelected(CommandSender sender) {
        if (sender instanceof Player) {
            List metadata = ((Player)sender).getMetadata("selected");
            if (metadata.size() == 0) {
                return null;
            }
            return CitizensAPI.getNPCRegistry().getById(((MetadataValue)metadata.get(0)).asInt());
        }
        if (this.consoleSelectedNPC == -1) {
            return null;
        }
        return CitizensAPI.getNPCRegistry().getById(this.consoleSelectedNPC);
    }

    @EventHandler
    public void onNPCRemove(NPCRemoveEvent event) {
        NPC npc = event.getNPC();
        List selectors = (List)npc.data().get("selectors");
        if (selectors == null) {
            return;
        }
        for (String value : selectors) {
            if (value.equals("console")) {
                this.consoleSelectedNPC = -1;
                continue;
            }
            Player search = Bukkit.getPlayerExact((String)value);
            if (search == null) continue;
            search.removeMetadata("selected", this.plugin);
        }
        npc.data().remove("selectors");
    }

    @EventHandler
    public void onNPCRightClick(NPCRightClickEvent event) {
        Player player = event.getClicker();
        NPC npc = event.getNPC();
        List selected = player.getMetadata("selected");
        if ((selected == null || selected.size() == 0 || ((MetadataValue)selected.get(0)).asInt() != npc.getId()) && Util.isSettingFulfilled(player, Settings.Setting.SELECTION_ITEM) && npc.getTrait(Owner.class).isOwnedBy((CommandSender)player)) {
            player.removeMetadata("selected", this.plugin);
            this.select((CommandSender)player, npc);
            Messaging.sendWithNPC((CommandSender)player, Settings.Setting.SELECTION_MESSAGE.asString(), npc);
            if (!Settings.Setting.QUICK_SELECT.asBoolean()) {
                return;
            }
        }
    }

    public void select(CommandSender sender, NPC npc) {
        List selectors = npc.data().get("selectors", Lists.newArrayList());
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (player.hasMetadata("selected")) {
                player.removeMetadata("selected", this.plugin);
            }
            player.setMetadata("selected", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)npc.getId()));
            selectors.add(player.getName());
            Editor.leave(player);
        } else {
            this.consoleSelectedNPC = npc.getId();
            selectors.add("console");
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCSelectEvent(npc, sender));
    }
}

