/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import java.io.File;
import java.sql.SQLException;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.DatabaseStorage;
import net.citizensnpcs.api.util.NBTStorage;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.CitizensNPCRegistry;
import net.citizensnpcs.util.Messaging;
import org.bukkit.entity.EntityType;

public class NPCDataStore {
    private final Storage root;

    private NPCDataStore(Storage saves) {
        this.root = saves;
    }

    public void loadInto(CitizensNPCRegistry registry) {
        int created = 0;
        int spawned = 0;
        for (DataKey key : this.root.getKey("npc").getIntegerSubKeys()) {
            int id = Integer.parseInt(key.name());
            if (!key.keyExists("name")) {
                Messaging.logF("Could not find a name for the NPC with ID '%s'.", id);
                continue;
            }
            String unparsedEntityType = key.getString("traits.type", "PLAYER");
            EntityType type = EntityType.fromName((String)unparsedEntityType);
            if (type == null) {
                try {
                    type = EntityType.valueOf((String)unparsedEntityType);
                }
                catch (IllegalArgumentException ex) {
                    Messaging.logF("NPC type '%s' was not recognized. Did you spell it correctly?", unparsedEntityType);
                    continue;
                }
            }
            NPC npc = registry.createNPC(type, id, key.getString("name"));
            ((CitizensNPC)npc).load(key);
            ++created;
            if (!npc.isSpawned()) continue;
            ++spawned;
        }
        Messaging.logF("Loaded %d NPCs (%d spawned).", created, spawned);
    }

    public void remove(NPC npc) {
        this.root.getKey("npc").removeKey(Integer.toString(npc.getId()));
    }

    public void saveToDisk() {
        new Thread(){

            @Override
            public void run() {
                NPCDataStore.this.root.save();
            }
        }.start();
    }

    public void saveToDiskImmediate() {
        this.root.save();
    }

    public void store(NPC npc) {
        ((CitizensNPC)npc).save(this.root.getKey("npc." + npc.getId()));
    }

    public static NPCDataStore create(File folder) {
        Storage saves = null;
        String type = Settings.Setting.STORAGE_TYPE.asString();
        if (type.equalsIgnoreCase("db") || type.equalsIgnoreCase("database")) {
            try {
                saves = new DatabaseStorage(Settings.Setting.DATABASE_DRIVER.asString(), Settings.Setting.DATABASE_URL.asString(), Settings.Setting.DATABASE_USERNAME.asString(), Settings.Setting.DATABASE_PASSWORD.asString());
            }
            catch (SQLException e) {
                e.printStackTrace();
                Messaging.log("Unable to connect to database, falling back to YAML");
            }
        } else if (type.equalsIgnoreCase("nbt")) {
            saves = new NBTStorage(folder + File.separator + Settings.Setting.STORAGE_FILE.asString(), "Citizens NPC Storage");
        }
        if (saves == null) {
            saves = new YamlStorage(new File(folder, Settings.Setting.STORAGE_FILE.asString()), "Citizens NPC Storage");
        }
        if (!saves.load()) {
            return null;
        }
        Messaging.logF("Save method set to %s.", saves.toString());
        return new NPCDataStore(saves);
    }
}

