/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Camel;
import org.bukkit.entity.EntityType;

@TraitName(value="cameltrait")
public class CamelTrait
extends Trait {
    @Persist
    private CamelPose pose;

    public CamelTrait() {
        super("cameltrait");
    }

    public CamelPose getPose() {
        return this.pose;
    }

    @Override
    public void run() {
        if (this.pose != null && this.npc.isSpawned() && this.npc.getEntity() instanceof Camel) {
            NMS.setCamelPose(this.npc.getEntity(), this.pose);
        }
    }

    public void setPose(CamelPose pose) {
        this.pose = pose;
    }

    @Command(aliases={"npc"}, usage="camel (--pose pose)", desc="", modifiers={"camel"}, min=1, max=1, permission="citizens.npc.camel")
    @Requirements(selected=true, ownership=true, types={EntityType.CAMEL})
    public static void camel(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"pose"}) CamelPose pose) throws CommandException {
        CamelTrait trait = npc.getOrAddTrait(CamelTrait.class);
        String output = "";
        if (pose != null) {
            trait.setPose(pose);
            output = output + Messaging.tr("citizens.commands.npc.camel.pose-set", new Object[]{pose});
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }

    public static enum CamelPose {
        PANIC,
        SITTING,
        STANDING;

    }
}

