/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Position;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class Positions
extends Trait {
    private final List<Position> positions = new ArrayList<Position>();
    Position currentPosition = null;

    public Positions() {
        super("positions");
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        for (DataKey sub : key.getRelative("list").getIntegerSubKeys()) {
            try {
                this.positions.add(new Position(sub.getString("").split(";")[0], Float.valueOf(sub.getString("").split(";")[1]).floatValue(), Float.valueOf(sub.getString("").split(";")[2]).floatValue()));
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("list");
        for (int i = 0; i < this.positions.size(); ++i) {
            key.setString("list." + String.valueOf(i), this.positions.get(i).stringValue());
        }
    }

    public List<Position> getPositions() {
        return this.positions;
    }

    public boolean addPosition(String name, Location location) {
        Position newPosition = new Position(name, location.getPitch(), location.getYaw());
        if (this.positions.contains(newPosition)) {
            return false;
        }
        this.positions.add(newPosition);
        return true;
    }

    public boolean removePosition(Position position) {
        if (this.positions.contains(position)) {
            this.positions.remove(position);
            return true;
        }
        return false;
    }

    public Position getPosition(String name) {
        for (Position position : this.positions) {
            if (!position.getName().equalsIgnoreCase(name)) continue;
            return position;
        }
        return null;
    }

    public void assumePosition(Position position) {
        if (!this.npc.isSpawned()) {
            this.npc.spawn(this.npc.getTrait(CurrentLocation.class).getLocation());
        }
        Util.assumePosition((Entity)this.npc.getBukkitEntity(), position);
    }
}

