/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.util.ChunkCoord;
import org.bukkit.Chunk;
import org.bukkit.plugin.Plugin;

@TraitName(value="chunktickettrait")
public class ChunkTicketTrait
extends Trait {
    private ChunkCoord active;
    private int ticks;
    private long timeout;
    private static boolean SUPPORT_CHUNK_TICKETS = true;

    public ChunkTicketTrait() {
        super("chunktickettrait");
    }

    @Override
    public void onDespawn() {
        if (!SUPPORT_CHUNK_TICKETS) {
            return;
        }
        if (this.active != null) {
            this.active.getChunk().removePluginChunkTicket(CitizensAPI.getPlugin());
            this.active = null;
            this.ticks = 0;
            this.timeout = System.currentTimeMillis() + 1000L;
        }
    }

    @Override
    public void onSpawn() {
        if (!SUPPORT_CHUNK_TICKETS) {
            return;
        }
        if (this.npc.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())).booleanValue()) {
            this.ticks = -1;
        }
        Chunk chunk = this.npc.getEntity().getLocation().getChunk();
        this.active = new ChunkCoord(chunk);
        this.active.getChunk().addPluginChunkTicket(CitizensAPI.getPlugin());
        if (this.ticks >= 0 && SpigotUtil.getVersion()[1] <= 21 && (SpigotUtil.getVersion().length < 3 || SpigotUtil.getVersion()[2] <= 8) && this.timeout < System.currentTimeMillis()) {
            this.ticks = 2;
        }
    }

    @Override
    public void run() {
        if (!SUPPORT_CHUNK_TICKETS) {
            return;
        }
        if (this.ticks > 0) {
            --this.ticks;
            if (this.ticks == 0) {
                this.onDespawn();
            }
            if (this.active != null) {
                Chunk chunk = this.npc.getEntity().getLocation().getChunk();
                ChunkCoord next = new ChunkCoord(chunk);
                if (!next.equals(this.active)) {
                    this.active.getChunk().removePluginChunkTicket(CitizensAPI.getPlugin());
                    chunk.addPluginChunkTicket(CitizensAPI.getPlugin());
                    this.active = next;
                } else {
                    chunk.addPluginChunkTicket(CitizensAPI.getPlugin());
                }
            }
        }
    }

    static {
        try {
            Chunk.class.getMethod("removePluginChunkTicket", Plugin.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            SUPPORT_CHUNK_TICKETS = false;
        }
    }
}

