/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

public abstract class DataKey {
    private static final Predicate<DataKey> SIMPLE_INTEGER_FILTER = new Predicate<DataKey>(){

        public boolean apply(DataKey key) {
            try {
                Integer.parseInt(key.name());
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
    };

    public abstract boolean getBoolean(String var1);

    public boolean getBoolean(String key, boolean value) {
        if (this.keyExists(key)) {
            return this.getBoolean(key);
        }
        this.setBoolean(key, value);
        return value;
    }

    public abstract double getDouble(String var1);

    public double getDouble(String key, double value) {
        if (this.keyExists(key)) {
            return this.getDouble(key);
        }
        this.setDouble(key, value);
        return value;
    }

    public abstract int getInt(String var1);

    public int getInt(String key, int value) {
        if (this.keyExists(key)) {
            return this.getInt(key);
        }
        this.setInt(key, value);
        return value;
    }

    public Iterable<DataKey> getIntegerSubKeys() {
        return Iterables.filter(this.getSubKeys(), SIMPLE_INTEGER_FILTER);
    }

    public abstract long getLong(String var1);

    public long getLong(String key, long value) {
        if (this.keyExists(key)) {
            return this.getLong(key);
        }
        this.setLong(key, value);
        return value;
    }

    public abstract Object getRaw(String var1);

    public abstract DataKey getRelative(String var1);

    public abstract String getString(String var1);

    public String getString(String key, String value) {
        if (this.keyExists(key)) {
            return this.getString(key);
        }
        this.setString(key, value);
        return value;
    }

    public abstract Iterable<DataKey> getSubKeys();

    public abstract boolean keyExists(String var1);

    public abstract String name();

    public abstract void removeKey(String var1);

    public abstract void setBoolean(String var1, boolean var2);

    public abstract void setDouble(String var1, double var2);

    public abstract void setInt(String var1, int var2);

    public abstract void setLong(String var1, long var2);

    public abstract void setRaw(String var1, Object var2);

    public abstract void setString(String var1, String var2);
}

