/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.citizensnpcs.util.Messages;

public class Translator {
    private ResourceBundle bundle;
    private final Map<String, MessageFormat> messageFormatCache = Maps.newHashMap();
    private final File resourceFile;
    private static Translator instance;
    public static final String PREFIX = "messages";

    private Translator(File resourceFile, Locale locale) {
        this.resourceFile = resourceFile;
        try {
            this.bundle = ResourceBundle.getBundle(PREFIX, locale, new FileClassLoader(Translator.class.getClassLoader(), resourceFile));
        }
        catch (MissingResourceException e) {
            this.bundle = this.getDefaultBundle();
        }
    }

    public String format(String key, Object ... msg) {
        String unreplaced = this.translate(key);
        MessageFormat formatter = this.getFormatter(unreplaced);
        return formatter.format(msg);
    }

    private ResourceBundle getDefaultBundle() {
        return Messages.getDefaultResourceBundle(this.resourceFile, "messages_en.properties");
    }

    private MessageFormat getFormatter(String unreplaced) {
        MessageFormat formatter = this.messageFormatCache.get(unreplaced);
        if (formatter == null) {
            formatter = new MessageFormat(unreplaced);
            this.messageFormatCache.put(unreplaced, formatter);
        }
        return formatter;
    }

    public String translate(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            try {
                return this.getDefaultBundle().getString(key);
            }
            catch (MissingResourceException ex) {
                return "?" + key + "?";
            }
        }
    }

    public static void setInstance(File resourceFile, Locale locale) {
        instance = new Translator(resourceFile, locale);
    }

    public static String tr(Messages key) {
        return Translator.tr(key.getKey(), new Object[0]);
    }

    public static String tr(Messages key, Object ... msg) {
        return Translator.tr(key.getKey(), msg);
    }

    public static String tr(String key, Object ... msg) {
        return msg.length == 0 ? instance.translate(key) : instance.format(key, msg);
    }

    private static class FileClassLoader
    extends ClassLoader {
        private final File folder;

        public FileClassLoader(ClassLoader classLoader, File folder) {
            super(classLoader);
            this.folder = folder;
        }

        @Override
        public URL getResource(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return super.getResource(string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return super.getResourceAsStream(string);
        }
    }
}

