/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.OldEnumCompat;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

@TraitName(value="villagertrait")
public class VillagerTrait
extends Trait {
    @Persist
    private int level = 1;
    @Persist
    private Villager.Type type;

    public VillagerTrait() {
        super("villagertrait");
    }

    public int getLevel() {
        return this.level;
    }

    public Villager.Type getType() {
        return this.type;
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof Villager)) {
            return;
        }
        if (this.type != null) {
            ((Villager)this.npc.getEntity()).setVillagerType(this.type);
        }
        this.level = Math.min(5, Math.max(1, this.level));
        ((Villager)this.npc.getEntity()).setVillagerLevel(this.level);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setType(Villager.Type type) {
        this.type = type;
    }

    @Command(aliases={"npc"}, usage="villager (--level level) (--type type) (--profession profession) -s(hake head)", desc="", modifiers={"villager"}, min=1, max=1, flags="s", permission="citizens.npc.villager")
    @Requirements(selected=true, ownership=true, types={EntityType.VILLAGER})
    public static void villager(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"profession"}) Villager.Profession profession, @Flag(value={"type"}) Villager.Type type, @Flag(value={"level"}) Integer level) throws CommandException {
        VillagerTrait trait = npc.getOrAddTrait(VillagerTrait.class);
        String output = "";
        if (level != null) {
            if (level < 0) {
                throw new CommandUsageException();
            }
            trait.setLevel(level);
            output = output + " " + Messaging.tr("citizens.commands.npc.villager.level-set", level);
        }
        if (args.hasValueFlag("type")) {
            if (type == null) {
                throw new CommandException("citizens.commands.npc.villager.invalid-type", Util.listValuesPretty(OldEnumCompat.VillagerTypeEnum.values()));
            }
            trait.setType(type);
            output = output + " " + Messaging.tr("citizens.commands.npc.villager.type-set", args.getFlag("type"));
        }
        if (args.hasValueFlag("profession")) {
            if (profession == null) {
                throw new CommandException("citizens.commands.npc.profession.invalid-profession", args.getFlag("profession"), Util.listValuesPretty(OldEnumCompat.VillagerProfessionEnum.values()));
            }
            npc.getOrAddTrait(VillagerProfession.class).setProfession(profession);
            output = output + " " + Messaging.tr("citizens.commands.npc.profession.set", npc.getName(), args.getFlag("profession"));
        }
        if (args.hasFlag('s')) {
            ((Villager)npc.getEntity()).shakeHead();
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }
}

