/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public abstract class AbstractEntityController
implements EntityController {
    private Entity bukkitEntity;

    @Override
    public void create(Location at, NPC npc) {
        this.bukkitEntity = this.createEntity(at, npc);
        if (npc != null) {
            this.bukkitEntity.setMetadata("NPC", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
            this.bukkitEntity.setMetadata("NPC-ID", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)npc.getId()));
        }
    }

    protected abstract Entity createEntity(Location var1, NPC var2);

    @Override
    public void die() {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.removeMetadata("NPC", CitizensAPI.getPlugin());
        this.bukkitEntity.removeMetadata("NPC-ID", CitizensAPI.getPlugin());
        this.bukkitEntity = null;
    }

    @Override
    public Entity getBukkitEntity() {
        return this.bukkitEntity;
    }

    @Override
    public void remove() {
        if (this.bukkitEntity == null) {
            return;
        }
        if (this.bukkitEntity instanceof Player) {
            NMS.removeFromWorld(this.bukkitEntity);
            NMS.remove(this.bukkitEntity);
        } else {
            this.bukkitEntity.remove();
        }
        this.bukkitEntity.removeMetadata("NPC", CitizensAPI.getPlugin());
        this.bukkitEntity.removeMetadata("NPC-ID", CitizensAPI.getPlugin());
        this.bukkitEntity = null;
    }

    @Override
    public boolean spawn(Location at) {
        return !Util.isLoaded(at) ? false : NMS.addEntityToWorld(this.bukkitEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }
}

