/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@TraitName(value="displaytrait")
public class DisplayTrait
extends Trait {
    @Persist
    private Display.Billboard billboard;
    @Persist
    private Integer blockLight;
    @Persist
    private Float height;
    @Persist
    private Integer interpolationDelay;
    @Persist
    private Integer interpolationDuration;
    @Persist
    private Quaternionf leftRotation;
    @Persist
    private Vector3f offset;
    @Persist
    private Quaternionf rightRotation;
    @Persist
    private Vector3f scale;
    @Persist
    private Float shadowRadius;
    @Persist
    private Float shadowStrength;
    @Persist
    private Integer skyLight;
    @Persist
    private Float viewRange;
    @Persist
    private Float width;

    public DisplayTrait() {
        super("displaytrait");
    }

    @Override
    public void onSpawn() {
        Display display = (Display)this.npc.getEntity();
        if (this.billboard != null) {
            display.setBillboard(this.billboard);
        }
        if (this.blockLight != null && this.skyLight != null) {
            display.setBrightness(new Display.Brightness(this.blockLight.intValue(), this.skyLight.intValue()));
        }
        if (this.interpolationDelay != null) {
            display.setInterpolationDelay(this.interpolationDelay.intValue());
        }
        if (this.interpolationDuration != null) {
            display.setInterpolationDuration(this.interpolationDuration.intValue());
        }
        if (this.height != null) {
            display.setDisplayHeight(this.height.floatValue());
        }
        if (this.width != null) {
            display.setDisplayWidth(this.width.floatValue());
        }
        Transformation tf = display.getTransformation();
        if (this.scale != null) {
            tf.getScale().set((Vector3fc)this.scale);
        }
        if (this.offset != null) {
            tf.getTranslation().set((Vector3fc)this.offset);
        }
        if (this.leftRotation != null) {
            tf.getLeftRotation().set((Quaternionfc)this.leftRotation);
        }
        if (this.rightRotation != null) {
            tf.getRightRotation().set((Quaternionfc)this.rightRotation);
        }
        display.setTransformation(tf);
        if (this.viewRange != null) {
            display.setViewRange(this.viewRange.floatValue());
        }
        if (this.shadowRadius != null) {
            display.setShadowRadius(this.shadowRadius.floatValue());
        }
        if (this.shadowStrength != null) {
            display.setShadowStrength(this.shadowStrength.floatValue());
        }
    }

    public void setBillboard(Display.Billboard billboard) {
        this.billboard = billboard;
    }

    public void setBrightness(Display.Brightness brightness) {
        this.blockLight = brightness.getBlockLight();
        this.skyLight = brightness.getSkyLight();
    }

    public void setHeight(Float height) {
        this.height = height;
    }

    public void setInterpolationDelay(Integer interpolationDelay) {
        this.interpolationDelay = interpolationDelay;
    }

    public void setInterpolationDuration(Integer interpolationDuration) {
        this.interpolationDuration = interpolationDuration;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public void setScale(Vector3f scale) {
        this.scale = scale;
    }

    public void setShadowRadius(Float shadowRadius) {
        this.shadowRadius = shadowRadius;
    }

    public void setShadowStrength(Float shadowStrength) {
        this.shadowStrength = shadowStrength;
    }

    public void setViewRange(Float viewRange) {
        this.viewRange = viewRange;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    @Command(aliases={"npc"}, usage="display --billboard [billboard] --brightness [blockLight,skyLight] --interpolationdelay [delay] --interpolationduration [duration] --height [height] --width [width] --scale [x,y,z] --viewrange [range] --leftrotation [x,y,z,w] --rightrotation [x,y,z,w] --offset [x,y,z]", desc="", modifiers={"display"}, min=1, max=1, permission="citizens.npc.display")
    @Requirements(selected=true, ownership=true, types={EntityType.ITEM_DISPLAY, EntityType.TEXT_DISPLAY, EntityType.BLOCK_DISPLAY})
    public static void display(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"billboard"}) Display.Billboard billboard, @Flag(value={"left_rotation"}) Quaternionf leftrotation, @Flag(value={"right_rotation"}) Quaternionf rightrotation, @Flag(value={"scale"}) Vector3f scale, @Flag(value={"offset"}) Vector3f offset, @Flag(value={"view_range"}) Float viewRange, @Flag(value={"brightness"}) String brightness, @Flag(value={"interpolation_delay"}) Integer interpolationDelay, @Flag(value={"interpolation_duration"}) Integer interpolationDuration, @Flag(value={"height"}) Float height, @Flag(value={"shadow_radius"}) Float shadowRadius, @Flag(value={"shadow_strength"}) Float shadowStrength, @Flag(value={"width"}) Float width) throws CommandException {
        DisplayTrait trait = npc.getOrAddTrait(DisplayTrait.class);
        String output = "";
        if (billboard != null) {
            trait.setBillboard(billboard);
        }
        if (brightness != null) {
            trait.setBrightness(new Display.Brightness(Integer.parseInt(brightness.split(",")[0]), Integer.parseInt(brightness.split(",")[1])));
        }
        if (offset != null) {
            trait.setOffset(offset);
        }
        if (interpolationDelay != null) {
            trait.setInterpolationDelay(interpolationDelay);
        }
        if (interpolationDuration != null) {
            trait.setInterpolationDuration(interpolationDuration);
        }
        if (shadowStrength != null) {
            trait.setShadowStrength(shadowStrength);
        }
        if (shadowRadius != null) {
            trait.setShadowRadius(shadowRadius);
        }
        if (width != null) {
            trait.setWidth(width);
        }
        if (height != null) {
            trait.setHeight(height);
        }
        if (viewRange != null) {
            trait.setViewRange(viewRange);
        }
        if (scale != null) {
            trait.setScale(scale);
        }
        if (npc.isSpawned()) {
            trait.onSpawn();
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output.trim());
        }
    }
}

