/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;

@TraitName(value="textdisplaytrait")
public class TextDisplayTrait
extends Trait {
    @Persist
    private TextDisplay.TextAlignment alignment;
    @Persist
    private Color bgcolor;
    @Persist
    private Integer lineWidth;
    @Persist
    private Boolean seeThrough;
    @Persist
    private Boolean shadowed;
    @Persist
    private String text;

    public TextDisplayTrait() {
        super("textdisplaytrait");
    }

    public TextDisplay.TextAlignment getAlignment() {
        return this.alignment;
    }

    public Color getBackgroundColor() {
        return this.bgcolor;
    }

    public Integer getLineWidth() {
        return this.lineWidth;
    }

    public String getText() {
        return this.text;
    }

    public Boolean isSeeThrough() {
        return this.seeThrough;
    }

    public Boolean isShadowed() {
        return this.shadowed;
    }

    @Override
    public void onSpawn() {
        TextDisplay display = (TextDisplay)this.npc.getEntity();
        if (this.text != null) {
            NMS.setTextDisplayComponent((Entity)display, Messaging.minecraftComponentFromRawMessage(this.text));
        }
        if (this.shadowed != null) {
            display.setShadowed(this.shadowed.booleanValue());
        }
        if (this.seeThrough != null) {
            display.setSeeThrough(this.seeThrough.booleanValue());
        }
        if (this.lineWidth != null) {
            display.setLineWidth(this.lineWidth.intValue());
        }
        if (this.alignment != null) {
            display.setAlignment(this.alignment);
        }
        if (this.bgcolor != null) {
            display.setBackgroundColor(this.bgcolor);
        }
    }

    public void setAlignment(TextDisplay.TextAlignment alignment) {
        this.alignment = alignment;
    }

    public void setBackgroundColor(Color bgcolor) {
        this.bgcolor = bgcolor;
    }

    public void setLineWidth(Integer lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setSeeThrough(Boolean seeThrough) {
        this.seeThrough = seeThrough;
    }

    public void setShadowed(Boolean shadowed) {
        this.shadowed = shadowed;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Command(aliases={"npc"}, usage="textdisplay --shadowed [true|false] --seethrough [true|false] --line_width [width] --text [text]", desc="", modifiers={"textdisplay"}, min=1, max=1, permission="citizens.npc.textdisplay")
    @Requirements(selected=true, ownership=true, types={EntityType.TEXT_DISPLAY})
    public static void display(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"shadowed"}) Boolean shadowed, @Flag(value={"seethrough"}) Boolean seethrough, @Flag(value={"line_width"}) Integer lineWidth, @Flag(value={"text"}) String text, @Flag(value={"bgcolor"}) Color bgcolor, @Flag(value={"alignment"}) TextDisplay.TextAlignment alignment) throws CommandException {
        TextDisplayTrait trait = npc.getOrAddTrait(TextDisplayTrait.class);
        String output = "";
        if (shadowed != null) {
            trait.setShadowed(shadowed);
        }
        if (seethrough != null) {
            trait.setSeeThrough(seethrough);
        }
        if (lineWidth != null) {
            trait.setLineWidth(lineWidth);
        }
        if (alignment != null) {
            trait.setAlignment(alignment);
        }
        if (bgcolor != null) {
            trait.setBackgroundColor(bgcolor);
        }
        if (text != null) {
            trait.setText(text);
        }
        if (npc.isSpawned()) {
            trait.onSpawn();
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output.trim());
        }
    }
}

