/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R6.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R6.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R6.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class, EntityTypes.S);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level) {
            this(types, level, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public void e_() {
            if (this.npc == null) {
                super.e_();
                return;
            }
            NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
            this.npc.update();
            if (this.npc.useMinecraftAI()) {
                super.e_();
                return;
            }
            if (this.eV()) {
                this.x(0.0f);
                return;
            }
            this.b.a(this.dM(), this.dX());
            float[][] pos = NMS.calculateDragonPositions(this.dX(), new double[][]{this.toa(this.b.a(0, 1.0f)), this.toa(this.b.a(5, 1.0f)), this.toa(this.b.a(10, 1.0f)), this.toa(this.b.a(12, 1.0f)), this.toa(this.b.a(14, 1.0f)), this.toa(this.b.a(16, 1.0f))});
            for (int j = 0; j < this.cD.length; ++j) {
                Vec3D vec3 = new Vec3D(this.cD[j].dK(), this.cD[j].dM(), this.cD[j].dQ());
                this.cD[j].a_(this.dK() + (double)pos[j][0], this.dM() + (double)pos[j][1], this.dQ() + (double)pos[j][2]);
                this.cD[j].Y = this.cD[j].ao = vec3.g;
                this.cD[j].Z = this.cD[j].ap = vec3.h;
                this.cD[j].aa = this.cD[j].aq = vec3.i;
            }
            if (this.dj() != null) {
                this.v(this.dj().getBukkitYaw() - 180.0f);
            }
            Vec3D mot = this.dI();
            if (mot.g != 0.0 || mot.h != 0.0 || mot.i != 0.0) {
                if (this.dj() == null) {
                    this.v(Util.getYawFromVelocity((Entity)this.getBukkitEntity(), mot.g, mot.i));
                }
                this.a(EnumMoveType.a, mot);
                mot = mot.d(0.98, 0.91, 0.98);
                this.k(mot);
            }
            if (NMSImpl.ENDERDRAGON_CHECK_WALLS != null && this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls()) {
                for (int i = 0; i < 3; ++i) {
                    try {
                        this.f |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.cD[i].de());
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                try {
                    NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.an(), this.an().a((net.minecraft.world.entity.Entity)this, this.cD[6].de().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.an(), this.an().a((net.minecraft.world.entity.Entity)this, this.cD[7].de().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    NMSImpl.ENDERDRAGON_HURT.invoke(this, this.an(), this.an().a((net.minecraft.world.entity.Entity)this, this.cD[0].de().g(1.0), IEntitySelector.e));
                    NMSImpl.ENDERDRAGON_HURT.invoke(this, this.an(), this.an().a((net.minecraft.world.entity.Entity)this, this.cD[1].de().g(1.0), IEntitySelector.e));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public void dR() {
            if (this.npc == null) {
                super.dR();
            }
        }

        protected SoundEffect p() {
            return NMSImpl.getSoundEffect(this.npc, super.p(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect f_() {
            return NMSImpl.getSoundEffect(this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fw() {
            return NMS.getJumpPower(this.npc, super.fw());
        }

        public int cR() {
            return NMS.getFallDistance(this.npc, super.cR());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction p_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.p_();
        }

        public boolean T_() {
            return NMSImpl.isLeashed(this.npc, () -> super.T_(), (EntityInsentient)this);
        }

        public boolean bU() {
            return this.npc == null ? super.bU() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB(this.npc, super.c(vec3));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected void d(WorldServer level, DamageSource source, float f) {
            if (this.npc == null) {
                return;
            }
            Vec3D old = this.dI();
            super.d(level, source, f);
            if (this.gE().a().h() == DragonControllerPhase.k) {
                this.k(old);
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().al().equals(this.an().al())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        private double[] toa(DragonFlightHistory.a sample) {
            return new double[]{sample.a(), sample.b()};
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dI().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entity);
        }
    }
}

