/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.util.Vector;

public class FlyingBlockExaminer
implements BlockExaminer.NeighbourGeneratorBlockExaminer {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final Material WEB = SpigotUtil.isUsing1_13API() ? Material.COBWEB : Material.valueOf((String)"WEB");

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        return BlockExaminer.StandableState.STANDABLE;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material in = source.getMaterialAt(pos);
        if (above == WEB || in == WEB) {
            return 0.5f;
        }
        return 0.0f;
    }

    @Override
    public List<PathPoint> getNeighbours(BlockSource source, PathPoint point) {
        ArrayList neighbours = Lists.newArrayList();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Vector mod;
                    if (x == 0 && y == 0 && z == 0 || (mod = point.getVector().clone().add(new Vector(x, y, z))).getY() < 0.0 || mod.getY() > 255.0 || mod.equals((Object)point.getVector())) continue;
                    neighbours.add(point.createAtOffset(mod));
                }
            }
        }
        return neighbours;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Material in;
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        if (MinecraftBlockExaminer.isLiquid(above, in = source.getMaterialAt(pos))) {
            return BlockExaminer.PassableState.IMPASSABLE;
        }
        return MinecraftBlockExaminer.canStandIn(above, in) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.IMPASSABLE;
    }
}

