/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R5.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R5.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R5.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R5.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R5.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftGhast;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ghast;

public class GhastController
extends MobEntityController {
    public GhastController() {
        super(EntityGhastNPC.class, EntityTypes.ae);
    }

    public Ghast getBukkitEntity() {
        return (Ghast)super.getBukkitEntity();
    }

    public static class EntityGhastNPC
    extends EntityGhast
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGhastNPC(EntityTypes<? extends EntityGhast> types, World level) {
            this(types, level, null);
        }

        public EntityGhastNPC(EntityTypes<? extends EntityGhast> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean p(bzm entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public void dJ() {
            if (this.npc == null) {
                super.dJ();
            }
        }

        public void a(WorldServer level) {
            if (this.npc != null) {
                this.npc.update();
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
            }
            super.a(level);
        }

        protected SoundEffect p() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.p(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((bzm)this, (CraftEntity)new GhastNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect f_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(byb damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fn() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fn());
        }

        public int cI() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cI());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean fC() {
            return this.npc != null;
        }

        public boolean R_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.R_(), (EntityInsentient)this);
        }

        public boolean bL() {
            return this.npc == null ? super.bL() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public void h(bzm entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(fdc save) {
            return this.npc == null ? super.c(save) : false;
        }

        public bzm b(fbl transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((bzm)this, transition);
        }

        public boolean a(bae<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dA().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class GhastNPC
    extends CraftGhast
    implements ForwardingNPCHolder {
        public GhastNPC(EntityGhastNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityGhast)entity);
        }
    }
}

