/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R5.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R5.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R5.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R5.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R5.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftTraderLlama;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TraderLlama;

public class TraderLlamaController
extends MobEntityController {
    public TraderLlamaController() {
        super(EntityTraderLlamaNPC.class, EntityTypes.bA);
    }

    public void create(Location at, NPC npc) {
        npc.getOrAddTrait(HorseModifiers.class);
        super.create(at, npc);
    }

    public TraderLlama getBukkitEntity() {
        return (TraderLlama)super.getBukkitEntity();
    }

    public static class EntityTraderLlamaNPC
    extends EntityLlamaTrader
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityTraderLlamaNPC(EntityTypes<? extends EntityLlamaTrader> types, World level) {
            this(types, level, null);
        }

        public EntityTraderLlamaNPC(EntityTypes<? extends EntityLlamaTrader> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                ((TraderLlama)this.getBukkitEntity()).setDomestication(((TraderLlama)this.getBukkitEntity()).getMaxDomestication());
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean p(bzm entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public boolean a(double f, float f1, byb damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dJ() {
            if (this.npc == null) {
                super.dJ();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(WorldServer level) {
            if (this.npc == null) {
                super.a(level);
            } else {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI()) {
                    super.a(level);
                }
                this.x(10);
                NMS.setStepHeight((Entity)this.getBukkitEntity(), (float)1.0f);
                this.npc.update();
            }
        }

        protected SoundEffect p() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.p(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((bzm)this, (CraftEntity)new TraderLlamaNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect f_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(byb damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fn() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fn());
        }

        public int cI() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cI());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean R_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.R_(), (EntityInsentient)this);
        }

        public boolean bL() {
            return this.npc == null ? super.bL() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public boolean eV() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.eV();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(bzm entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(fdc save) {
            return this.npc == null ? super.c(save) : false;
        }

        public bzm b(fbl transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((bzm)this, transition);
        }

        public void k(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.k(vec3d);
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(bae<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dA().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class TraderLlamaNPC
    extends CraftTraderLlama
    implements ForwardingNPCHolder {
        public TraderLlamaNPC(EntityTraderLlamaNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityLlamaTrader)entity);
        }
    }
}

