/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R6.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R6.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R6.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftMinecartCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;

public class MinecartCommandController
extends MobEntityController {
    public MinecartCommandController() {
        super(EntityMinecartCommandNPC.class, EntityTypes.E);
    }

    public Minecart getBukkitEntity() {
        return (Minecart)super.getBukkitEntity();
    }

    public static class EntityMinecartCommandNPC
    extends EntityMinecartCommandBlock
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityMinecartCommandNPC(EntityTypes<? extends EntityMinecartCommandBlock> types, World level) {
            this(types, level, null);
        }

        public EntityMinecartCommandNPC(EntityTypes<? extends EntityMinecartCommandBlock> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new MinecartCommandNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction p_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.p_();
        }

        public boolean bU() {
            return this.npc == null ? super.bU() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().al().equals(this.an().al())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void g() {
            super.g();
            if (this.npc != null) {
                this.npc.update();
                NMSImpl.minecartItemLogic((EntityMinecartAbstract)this);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dI().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class MinecartCommandNPC
    extends CraftMinecartCommand
    implements ForwardingNPCHolder {
        public MinecartCommandNPC(EntityMinecartCommandNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityMinecartCommandBlock)entity);
        }
    }
}

