/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R6.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R6.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R6.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftCreaking;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.Creaking;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CreakingController
extends MobEntityController {
    public CreakingController() {
        super(EntityCreakingNPC.class, EntityTypes.G);
    }

    public Creaking getBukkitEntity() {
        return (Creaking)super.getBukkitEntity();
    }

    public static class EntityCreakingNPC
    extends cxr
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityCreakingNPC(EntityTypes<? extends cxr> types, World level) {
            this(types, level, null);
        }

        public EntityCreakingNPC(EntityTypes<? extends cxr> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.x(true);
            }
        }

        public void q(cdv passenger) {
            if (this.npc == null || this.npc.useMinecraftAI()) {
                super.q(passenger);
                return;
            }
            if (passenger.du() != this) {
                throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
            }
            if (this.aS.isEmpty()) {
                this.aS = ImmutableList.of((Object)passenger);
            } else {
                ArrayList list = Lists.newArrayList((Iterable)this.aS);
                if (!this.an().D_() && passenger instanceof Player && !(this.dj() instanceof Player)) {
                    list.add(0, passenger);
                } else {
                    list.add(passenger);
                }
                this.aS = ImmutableList.copyOf((Collection)list);
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        public boolean n() {
            return this.npc == null || this.npc.useMinecraftAI() ? super.n() : true;
        }

        protected boolean p(cdv entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public boolean a(double f, float f1, cci damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public boolean gQ() {
            return this.npc == null || this.npc.useMinecraftAI() ? super.gQ() : true;
        }

        public void dR() {
            if (this.npc == null) {
                super.dR();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(WorldServer level) {
            super.a(level);
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        protected SoundEffect p() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.p(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((cdv)this, (CraftEntity)new CreakingNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect f_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(cci damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fw() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fw());
        }

        public int cR() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cR());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction p_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.p_();
        }

        public boolean gS() {
            return this.npc == null || this.npc.useMinecraftAI() ? super.gS() : true;
        }

        public boolean k() {
            if (this.npc == null || this.npc.useMinecraftAI()) {
                return super.k();
            }
            return this.npc.isProtected() ? false : super.k();
        }

        public boolean T_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.T_(), (EntityInsentient)this);
        }

        public boolean bU() {
            return this.npc == null ? super.bU() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public boolean fe() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.fe();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(cdv entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(fir save) {
            return this.npc == null ? super.c(save) : false;
        }

        public cdv b(fha transition) {
            if (this.npc == null || transition.b().al().equals(this.an().al())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((cdv)this, transition);
        }

        public void m(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.m(vec3d);
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(bdj<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dI().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class CreakingNPC
    extends CraftCreaking
    implements ForwardingNPCHolder {
        public CreakingNPC(EntityCreakingNPC entity) {
            super((CraftServer)Bukkit.getServer(), (cxr)entity);
        }
    }
}

