/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.LocationLookup;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.RemoveReason;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerUpdateTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@TraitName(value="packet")
public class PacketNPC
extends Trait {
    private EntityPacketTracker packetTracker;
    private boolean spawned = false;

    public PacketNPC() {
        super("packet");
    }

    public EntityPacketTracker getPacketTracker() {
        return this.packetTracker;
    }

    @Override
    public void onRemove(RemoveReason reason) {
        if (reason == RemoveReason.REMOVAL) {
            this.npc.despawn(DespawnReason.PENDING_RESPAWN);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (this.npc.getStoredLocation() != null) {
                    this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
                }
            });
        }
    }

    @Override
    public void onSpawn() {
        this.packetTracker = NMS.createPacketTracker(this.npc.getEntity());
        this.spawned = true;
    }

    @Override
    public void run() {
        if (!this.spawned) {
            return;
        }
        LocationLookup.PerPlayerMetadata<Boolean> ppm = CitizensAPI.getLocationLookup().registerMetadata("packetnpc", null);
        for (Player nearby : CitizensAPI.getLocationLookup().getNearbyPlayers(this.npc)) {
            if (ppm.has(nearby.getUniqueId(), this.npc.getUniqueId().toString())) continue;
            this.packetTracker.link(nearby);
            ppm.set(nearby.getUniqueId(), this.npc.getUniqueId().toString(), true);
        }
        this.packetTracker.run();
    }

    public EntityController wrap(EntityController controller) {
        if (!(controller instanceof PacketController)) {
            return new PacketController(controller);
        }
        return controller;
    }

    private class PacketController
    implements EntityController {
        private final EntityController base;

        public PacketController(EntityController controller) {
            this.base = controller;
        }

        @Override
        public void create(Location at, NPC npc) {
            this.base.create(at, npc);
        }

        @Override
        public void die() {
            this.base.die();
            if (!PacketNPC.this.spawned) {
                return;
            }
            PlayerUpdateTask.deregister(this.getBukkitEntity());
            LocationLookup.PerPlayerMetadata ppm = CitizensAPI.getLocationLookup().registerMetadata("packetnpc", null);
            PacketNPC.this.packetTracker.unlinkAll(player -> ppm.remove(player.getUniqueId(), PacketNPC.this.npc.getUniqueId().toString()));
            PacketNPC.this.spawned = false;
        }

        @Override
        public Entity getBukkitEntity() {
            return this.base.getBukkitEntity();
        }

        @Override
        public void remove() {
            if (!PacketNPC.this.spawned) {
                return;
            }
            PlayerUpdateTask.deregister(this.getBukkitEntity());
            LocationLookup.PerPlayerMetadata ppm = CitizensAPI.getLocationLookup().registerMetadata("packetnpc", null);
            PacketNPC.this.packetTracker.unlinkAll(player -> ppm.remove(player.getUniqueId(), PacketNPC.this.npc.getUniqueId().toString()));
            this.base.remove();
            PacketNPC.this.spawned = false;
        }

        @Override
        public boolean spawn(Location at) {
            NMS.setLocationDirectly(this.base.getBukkitEntity(), at);
            PlayerUpdateTask.register(this.getBukkitEntity());
            return true;
        }
    }
}

