/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R7.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R7.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R7.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R7.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R7.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class, EntityTypes.T);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level) {
            this(types, level, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public void d_() {
            if (this.npc == null) {
                super.d_();
                return;
            }
            NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
            this.npc.update();
            if (this.npc.useMinecraftAI()) {
                super.d_();
                return;
            }
            if (this.fa()) {
                this.x(0.0f);
                return;
            }
            this.b.a(this.dR(), this.ec());
            float[][] pos = NMS.calculateDragonPositions((float)this.ec(), (double[][])new double[][]{this.toa(this.b.a(0, 1.0f)), this.toa(this.b.a(5, 1.0f)), this.toa(this.b.a(10, 1.0f)), this.toa(this.b.a(12, 1.0f)), this.toa(this.b.a(14, 1.0f)), this.toa(this.b.a(16, 1.0f))});
            for (int j = 0; j < this.cF.length; ++j) {
                Vec3D vec3 = new Vec3D(this.cF[j].dP(), this.cF[j].dR(), this.cF[j].dV());
                this.cF[j].a_(this.dP() + (double)pos[j][0], this.dR() + (double)pos[j][1], this.dV() + (double)pos[j][2]);
                this.cF[j].Y = this.cF[j].ao = vec3.g;
                this.cF[j].Z = this.cF[j].ap = vec3.h;
                this.cF[j].aa = this.cF[j].aq = vec3.i;
            }
            if (this.do() != null) {
                this.v(this.do().getBukkitYaw() - 180.0f);
            }
            Vec3D mot = this.dN();
            if (mot.g != 0.0 || mot.h != 0.0 || mot.i != 0.0) {
                if (this.do() == null) {
                    this.v(Util.getYawFromVelocity((Entity)this.getBukkitEntity(), (double)mot.g, (double)mot.i));
                }
                this.a(EnumMoveType.a, mot);
                mot = mot.d(0.98, 0.91, 0.98);
                this.k(mot);
            }
            if (NMSImpl.ENDERDRAGON_CHECK_WALLS != null && this.npc.hasTrait(EnderDragonTrait.class) && ((EnderDragonTrait)this.npc.getOrAddTrait(EnderDragonTrait.class)).isDestroyWalls()) {
                for (int i = 0; i < 3; ++i) {
                    try {
                        this.f |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.cF[i].dj());
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            if (((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)false)).booleanValue()) {
                try {
                    NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.ao(), this.ao().a((net.minecraft.world.entity.Entity)this, this.cF[6].dj().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.ao(), this.ao().a((net.minecraft.world.entity.Entity)this, this.cF[7].dj().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    NMSImpl.ENDERDRAGON_HURT.invoke(this, this.ao(), this.ao().a((net.minecraft.world.entity.Entity)this, this.cF[0].dj().g(1.0), IEntitySelector.e));
                    NMSImpl.ENDERDRAGON_HURT.invoke(this, this.ao(), this.ao().a((net.minecraft.world.entity.Entity)this, this.cF[1].dj().g(1.0), IEntitySelector.e));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof AbstractBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public void dW() {
            if (this.npc == null) {
                super.dW();
            }
        }

        protected SoundEffect W() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.W(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect fd() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.fd(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect h(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.h(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fF() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fF());
        }

        public int cW() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cW());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public boolean S_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.S_(), (EntityInsentient)this);
        }

        public boolean bY() {
            return this.npc == null ? super.bY() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected void d(WorldServer level, DamageSource source, float f) {
            if (this.npc == null) {
                return;
            }
            Vec3D old = this.dN();
            super.d(level, source, f);
            if (this.gN().a().h() == DragonControllerPhase.k) {
                this.k(old);
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().aq().equals(this.ao().aq())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        private double[] toa(DragonFlightHistory.a sample) {
            return new double[]{sample.a(), sample.b()};
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dN().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entity);
        }
    }
}

