/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.UUID;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

@TraitName(value="owner")
public class Owner
extends Trait {
    @Persist
    private UUID uuid;

    public Owner() {
        super("owner");
    }

    @Deprecated
    public String getOwner() {
        return this.uuid == null ? "SERVER" : this.uuid.toString();
    }

    public UUID getOwnerId() {
        return this.uuid;
    }

    public boolean isOwnedBy(CommandSender sender) {
        if (sender == null) {
            return false;
        }
        if (this.uuid == null && sender instanceof ConsoleCommandSender) {
            return true;
        }
        return sender.hasPermission("citizens.ignore-owner") || sender.hasPermission("citizens.admin") || this.uuid != null && sender instanceof OfflinePlayer && ((OfflinePlayer)sender).getUniqueId().equals(this.uuid) || this.uuid != null && sender instanceof Player && ((Player)sender).getUniqueId().equals(this.uuid);
    }

    public boolean isOwnedBy(String name) {
        return this.uuid == null ? "SERVER".equals(name) : this.uuid != null && this.uuid.toString().equalsIgnoreCase(name);
    }

    public boolean isOwnedBy(UUID other) {
        return this.uuid == null ? other == null : this.uuid.equals(other);
    }

    public void setOwner(CommandSender sender) {
        this.uuid = sender instanceof OfflinePlayer ? ((OfflinePlayer)sender).getUniqueId() : (sender instanceof Player ? ((Player)sender).getUniqueId() : null);
    }

    @Deprecated
    public void setOwner(String owner) {
        this.setOwner(owner, null);
    }

    @Deprecated
    public void setOwner(String owner, UUID uuid) {
        this.uuid = uuid;
    }

    public void setOwner(UUID uuid) {
        this.uuid = uuid;
    }

    public String toString() {
        return "Owner{" + this.uuid + "}";
    }
}

