/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.command.exception.UnhandledCommandException;
import net.citizensnpcs.api.command.exception.WrappedCommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;

public class NPCCommandSelector
extends NumericPrompt {
    private final Callback callback;
    private final List<NPC> choices;

    public NPCCommandSelector(Callback callback, List<NPC> possible) {
        this.callback = callback;
        this.choices = possible;
    }

    protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
        boolean found = false;
        for (NPC npc : this.choices) {
            if (input.intValue() != npc.getId()) continue;
            found = true;
            break;
        }
        CommandSender sender = (CommandSender)context.getForWhom();
        if (!found) {
            Messaging.sendErrorTr(sender, "citizens.conversations.selection.invalid-choice", input);
            return this;
        }
        NPC toSelect = CitizensAPI.getNPCRegistry().getById(input.intValue());
        try {
            this.callback.run(toSelect);
        }
        catch (ServerCommandException ex) {
            Messaging.sendTr(sender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
        }
        catch (CommandUsageException ex) {
            Messaging.sendError(sender, ex.getMessage());
            Messaging.sendError(sender, ex.getUsage());
        }
        catch (UnhandledCommandException ex) {
            ex.printStackTrace();
        }
        catch (WrappedCommandException ex) {
            ex.getCause().printStackTrace();
        }
        catch (CommandException ex) {
            Messaging.sendError(sender, Messaging.tryTranslate(ex.getMessage()));
        }
        catch (NumberFormatException ex) {
            Messaging.sendErrorTr(sender, "citizens.commands.invalid-number", new Object[0]);
        }
        return null;
    }

    public String getPromptText(ConversationContext context) {
        String text = Messaging.tr("citizens.editors.selection.start-prompt", new Object[0]);
        for (NPC npc : this.choices) {
            text = text + "<br>    - " + npc.getId();
        }
        Messaging.send((CommandSender)context.getForWhom(), text);
        return "";
    }

    public static void start(Callback callback, Conversable player, List<NPC> possible) {
        Conversation conversation = new ConversationFactory(CitizensAPI.getPlugin()).withLocalEcho(false).withEscapeSequence("exit").withModality(false).withFirstPrompt((Prompt)new NPCCommandSelector(callback, possible)).buildConversation(player);
        conversation.begin();
    }

    public static void startWithCallback(Callback callback, NPCRegistry npcRegistry, CommandSender sender, CommandContext args, String raw) throws CommandException {
        try {
            UUID uuid = UUID.fromString(raw);
            callback.run(npcRegistry.getByUniqueIdGlobal(uuid));
            return;
        }
        catch (IllegalArgumentException uuid) {
            Integer id = Ints.tryParse((String)raw);
            if (id != null) {
                callback.run(npcRegistry.getById(id));
                return;
            }
            String name = args.getString(1);
            ArrayList possible = Lists.newArrayList();
            double range = -1.0;
            if (args.hasValueFlag("range")) {
                range = Math.abs(args.getFlagDouble("range"));
            }
            for (NPC test : npcRegistry) {
                if (!test.getName().equalsIgnoreCase(name) || range > 0.0 && test.isSpawned() && args.getSenderLocation().distance(test.getEntity().getLocation()) > range) continue;
                possible.add(test);
            }
            if (possible.size() == 1) {
                callback.run((NPC)possible.get(0));
            } else if (possible.size() > 1) {
                NPCCommandSelector.start(callback, (Conversable)sender, possible);
            }
            return;
        }
    }

    public static interface Callback {
        public void run(NPC var1) throws CommandException;
    }
}

