/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R6.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_21_R6.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R6.util.EntityNavigation;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public cku getJumpControl();

    public Map<fgr, Float> getMalus();

    public ckw getMoveControl();

    public coh getNavigation();

    default public float getPathfindingMalus(fgr var1) {
        Map<fgr, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(fgr water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        coh nav = this.getNavigation();
        if (!nav.l()) {
            nav.d();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((cew)NMSImpl.getHandle(this.getBukkitEntity())).h(cgc.n).a((double)range);
    }

    public static MobAI from(cdv handle) {
        if (handle instanceof cey) {
            final cey mob = (cey)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public cku getJumpControl() {
                    return mob.R();
                }

                @Override
                public Map<fgr, Float> getMalus() {
                    return null;
                }

                @Override
                public ckw getMoveControl() {
                    return mob.Q();
                }

                @Override
                public coh getNavigation() {
                    return mob.S();
                }

                @Override
                public float getPathfindingMalus(fgr var1) {
                    return mob.a(var1);
                }

                @Override
                public void setPathfindingMalus(fgr water, float oldWaterCost) {
                    mob.a(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.T().a();
                    mob.S().d();
                    mob.Q().a();
                    mob.P().a();
                    mob.R().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public cku getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<fgr, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public ckw getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public coh getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final cew entity;
        private final Map<fgr, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(cew entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, (jk<cfx>)cgc.n, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.h(cgc.w).a(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.an());
            this.malus = Maps.newEnumMap(fgr.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public cku getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<fgr, Float> getMalus() {
            return this.malus;
        }

        @Override
        public ckw getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public coh getNavigation() {
            return this.navigation;
        }
    }
}

