/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class EquipmentEditor
extends Editor {
    private final NPC npc;
    private final Player player;

    public EquipmentEditor(Player player, NPC npc) {
        this.player = player;
        this.npc = npc;
    }

    @Override
    public void begin() {
        Messaging.sendTr((CommandSender)this.player, "citizens.editors.equipment.begin-message", new Object[0]);
    }

    @Override
    public void end() {
        Messaging.sendTr((CommandSender)this.player, "citizens.editors.equipment.end-message", new Object[0]);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR && Editor.hasEditor(event.getPlayer())) {
            event.setUseItemInHand(Event.Result.DENY);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!event.getPlayer().equals(this.player) || !this.npc.equals(CitizensAPI.getNPCRegistry().getNPC(event.getRightClicked()))) {
            return;
        }
        if (this.npc instanceof Equipable) {
            ItemStack hand = event.getPlayer().getItemInHand();
            ((Equipable)((Object)this.npc)).equip(event.getPlayer(), hand);
            event.getPlayer().setItemInHand((ItemStack)(hand.getAmount() > 0 ? hand : null));
        }
    }
}

