/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.io.File;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.expr.ExpressionScope;
import net.citizensnpcs.api.expr.Memory;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.TemplateWorkspace;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.TraitTemplateParser;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.npc.ai.tree.BehaviorTreeParser;
import net.citizensnpcs.npc.ai.tree.NPCExpressionScope;

@TraitName(value="behavior")
public class BehaviorTrait
extends Trait {
    private Memory memory;
    private Behavior root;
    private Map<String, Object> yamlCache;

    public BehaviorTrait() {
        super("behavior");
    }

    public boolean applyBehaviorsFromFile(File file) {
        YamlStorage storage = new YamlStorage(file);
        if (!storage.load()) {
            return false;
        }
        this.applyBehaviorsFromKey(storage.getKey(""));
        return true;
    }

    public void applyBehaviorsFromKey(DataKey key) {
        if (this.root != null) {
            this.npc.getDefaultGoalController().removeBehavior(this.root);
            this.root = null;
        }
        MemoryDataKey load = new MemoryDataKey();
        Map<String, Object> values = key.getValuesDeep();
        ((DataKey)load).setMap("tree", values);
        this.yamlCache = values;
        this.load(load);
    }

    public Memory getMemory() {
        return this.memory;
    }

    @Override
    public void load(DataKey key) {
        if (key.keyExists("tree")) {
            this.parse(key.getRelative("tree"));
        }
        if (key.keyExists("memory")) {
            if (this.memory == null) {
                this.memory = new Memory();
            }
            this.memory.loadFrom(key.getRelative("memory"));
        }
    }

    @Override
    public void onDespawn() {
        if (this.root != null) {
            this.npc.getDefaultGoalController().removeBehavior(this.root);
            this.root = null;
        }
    }

    private void parse(DataKey yaml) {
        if (!yaml.hasSubKeys()) {
            return;
        }
        if (this.memory == null) {
            this.memory = new Memory();
        }
        ExpressionScope scope = NPCExpressionScope.createFor(this.npc);
        BehaviorTreeParser parser = new BehaviorTreeParser(CitizensAPI.getBehaviorRegistry());
        Behavior parsed = parser.parse(yaml.getSubKeys().iterator().next(), this.npc, scope, this.memory);
        if (parsed == null) {
            return;
        }
        this.root = new RootBehavior(parsed, scope);
        this.npc.getDefaultGoalController().addBehavior(this.root, 1);
    }

    @Override
    public void save(DataKey key) {
        if (this.memory != null) {
            this.memory.saveTo(key.getRelative("memory"));
        }
        if (this.yamlCache != null) {
            key.setMap("tree", this.yamlCache);
            this.yamlCache = null;
        }
    }

    public static TraitTemplateParser createTemplateParser() {
        return new TraitTemplateParser(){

            @Override
            public TraitTemplateParser.ShortTemplateParser getShortTemplateParser() {
                return (ctx, cmdCtx) -> {
                    if (cmdCtx.argsLength() < 2) {
                        return null;
                    }
                    String fileName = cmdCtx.getJoinedStrings(1);
                    return this.loadFromFile(ctx.npc, ctx.workspace, fileName);
                };
            }

            @Override
            public TraitTemplateParser.TemplateParser getTemplateParser() {
                return (ctx, key) -> {
                    BehaviorTrait trait = ctx.npc.getOrAddTrait(BehaviorTrait.class);
                    trait.applyBehaviorsFromKey(key.getRelative("tree"));
                    return null;
                };
            }

            private BehaviorTrait loadFromFile(NPC npc, TemplateWorkspace workspace, String fileName) {
                File file;
                File file2 = file = workspace != null ? workspace.getFile(fileName) : null;
                if (file == null) {
                    file = new File(CitizensAPI.getDataFolder(), "behaviors/" + fileName);
                }
                if (!file.exists()) {
                    Messaging.severe("Behavior file not found", fileName);
                    return null;
                }
                BehaviorTrait trait = npc.getOrAddTrait(BehaviorTrait.class);
                if (!trait.applyBehaviorsFromFile(file)) {
                    Messaging.severe("Failed to load behavior tree from", fileName);
                }
                return null;
            }
        };
    }

    private static class RootBehavior
    implements Behavior {
        boolean failed;
        BehaviorStatus lastStatus;
        final Behavior root;
        final ExpressionScope scope;

        public RootBehavior(Behavior root, ExpressionScope scope) {
            this.root = root;
            this.scope = scope;
        }

        @Override
        public void reset() {
            this.root.reset();
            this.lastStatus = null;
        }

        @Override
        public BehaviorStatus run() {
            this.scope.resetCache();
            try {
                this.lastStatus = this.root.run();
            }
            catch (Throwable t) {
                if (!this.failed) {
                    Messaging.severe("Error while running behavior tree:");
                    t.printStackTrace();
                    this.failed = true;
                }
                this.lastStatus = BehaviorStatus.FAILURE;
            }
            if (this.lastStatus == BehaviorStatus.SUCCESS || this.lastStatus == BehaviorStatus.FAILURE) {
                this.root.reset();
            }
            return this.lastStatus;
        }

        @Override
        public boolean shouldExecute() {
            return !this.failed && this.root != null && this.root.shouldExecute();
        }
    }
}

