/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.npc.EntityControllers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

@TraitName(value="disguise")
public class DisguiseTrait
extends Trait {
    private EntityController synthetic;
    @Persist
    private EntityType type;

    public DisguiseTrait() {
        super("disguise");
    }

    public void disguiseAsType(EntityType type) {
        this.type = type;
        if (this.npc.isSpawned()) {
            this.npc.despawn(DespawnReason.PENDING_RESPAWN);
            this.npc.spawn(this.npc.getStoredLocation());
        }
    }

    public Entity getCosmeticEntity() {
        if (this.type == null || this.synthetic == null) {
            return null;
        }
        return this.synthetic.getBukkitEntity();
    }

    @Override
    public void onDespawn() {
        this.synthetic = null;
    }

    @Override
    public void onSpawn() {
        if (this.type == null) {
            return;
        }
        this.synthetic = EntityControllers.createForType(this.type);
        this.synthetic.create(this.npc.getEntity().getLocation(), this.npc);
    }
}

