/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.schedulers.SchedulerRunnable;
import net.citizensnpcs.api.util.schedulers.SchedulerTask;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.SitTrait;
import net.citizensnpcs.trait.SleepTrait;
import net.citizensnpcs.trait.SneakTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public enum PlayerAnimation {
    ARM_SWING,
    ARM_SWING_OFFHAND,
    CRIT,
    EAT_FOOD,
    HURT,
    LEAVE_BED,
    MAGIC_CRIT,
    SIT,
    SLEEP,
    SNEAK,
    START_ELYTRA,
    START_USE_MAINHAND_ITEM,
    START_USE_OFFHAND_ITEM,
    STOP_ELYTRA,
    STOP_SITTING,
    STOP_SLEEPING,
    STOP_SNEAKING,
    STOP_USE_ITEM;

    private static final Set<Material> BAD_ITEMS_TO_USE;

    public void play(Player player) {
        this.play(player, 64);
    }

    public void play(Player from, int radius) {
        this.play(from, () -> Lists.newArrayList(CitizensAPI.getLocationLookup().getNearbyPlayers(from.getLocation(), radius)));
    }

    public void play(Player player, Iterable<Player> to) {
        this.play(player, () -> to);
    }

    public void play(Player player, Player to) {
        this.play(player, () -> ImmutableList.of((Object)to));
    }

    public void play(final Player player, final Supplier<Iterable<Player>> to) {
        if (this == SNEAK) {
            if (player instanceof NPCHolder) {
                ((NPCHolder)player).getNPC().getOrAddTrait(SneakTrait.class).setSneaking(true);
                return;
            }
        } else if (this == STOP_SNEAKING) {
            if (player instanceof NPCHolder) {
                ((NPCHolder)player).getNPC().getOrAddTrait(SneakTrait.class).setSneaking(false);
                return;
            }
        } else {
            if (this == SIT) {
                if (player instanceof NPCHolder) {
                    ((NPCHolder)player).getNPC().getOrAddTrait(SitTrait.class).setSitting(player.getLocation());
                    return;
                }
                player.setMetadata("citizens.sitting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
                final NPC holder = CitizensAPI.getTemporaryNPCRegistry().createNPC(EntityType.ARMOR_STAND, "");
                holder.getOrAddTrait(ArmorStandTrait.class).setAsPointEntity();
                holder.spawn(player.getLocation());
                new SchedulerRunnable(){

                    @Override
                    public void cancel() {
                        super.cancel();
                        holder.destroy();
                    }

                    @Override
                    public void run() {
                        if (!(player.isValid() && player.hasMetadata("citizens.sitting") && ((MetadataValue)player.getMetadata("citizens.sitting").get(0)).asBoolean())) {
                            this.cancel();
                            return;
                        }
                        if (!NMS.getPassengers(holder.getEntity()).contains(player)) {
                            NMS.mount(holder.getEntity(), (Entity)player);
                        }
                    }
                }.runEntityTaskTimer(CitizensAPI.getPlugin(), holder.getEntity(), null, 0L, 1L);
                return;
            }
            if (this == STOP_SITTING) {
                if (player instanceof NPCHolder) {
                    ((NPCHolder)player).getNPC().getOrAddTrait(SitTrait.class).setSitting(null);
                    return;
                }
                player.setMetadata("citizens.sitting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)false));
                NMS.mount((Entity)player, null);
                return;
            }
            if (this == SLEEP) {
                if (player instanceof NPCHolder) {
                    ((NPCHolder)player).getNPC().getOrAddTrait(SleepTrait.class).setSleeping(player.getLocation());
                } else {
                    NMS.sleep(player, true);
                }
                return;
            }
            if (this == STOP_SLEEPING) {
                if (player instanceof NPCHolder) {
                    ((NPCHolder)player).getNPC().getOrAddTrait(SleepTrait.class).setSleeping(null);
                } else {
                    NMS.sleep(player, false);
                }
                return;
            }
            if (this == STOP_USE_ITEM || this == START_USE_MAINHAND_ITEM || this == START_USE_OFFHAND_ITEM) {
                ItemStack using;
                NMS.playAnimation(this, player, to.get());
                if (player.hasMetadata("citizens-using-item")) {
                    SchedulerTask task = (SchedulerTask)((MetadataValue)player.getMetadata("citizens-using-item").get(0)).value();
                    task.cancel();
                    player.removeMetadata("citizens-using-item", CitizensAPI.getPlugin());
                }
                if (this == STOP_USE_ITEM) {
                    return;
                }
                ItemStack itemStack = using = this == START_USE_MAINHAND_ITEM ? player.getItemInHand() : player.getInventory().getItemInOffHand();
                if (using != null && BAD_ITEMS_TO_USE.contains(using.getType()) && player.hasMetadata("citizens-using-item-remaining-ticks")) {
                    int remainingTicks = ((MetadataValue)player.getMetadata("citizens-using-item-remaining-ticks").get(0)).asInt();
                    new SchedulerRunnable(){

                        @Override
                        public void run() {
                            if (!NMS.isValid((Entity)player)) {
                                this.cancel();
                                return;
                            }
                            NMS.playAnimation(STOP_USE_ITEM, player, (Iterable)to.get());
                            NMS.playAnimation(PlayerAnimation.this, player, (Iterable)to.get());
                            if (!player.hasMetadata("citizens-using-item")) {
                                player.setMetadata("citizens-using-item", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)this));
                            }
                        }
                    }.runEntityTaskTimer(CitizensAPI.getPlugin(), (Entity)player, null, Math.max(0, remainingTicks + 1), Math.max(1, remainingTicks + 1));
                }
                return;
            }
        }
        NMS.playAnimation(this, player, to.get());
    }

    static {
        BAD_ITEMS_TO_USE = EnumSet.noneOf(Material.class);
        try {
            BAD_ITEMS_TO_USE.add(Material.valueOf((String)"SPYGLASS"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

