/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sniffer;

@TraitName(value="sniffertrait")
public class SnifferTrait
extends Trait {
    @Persist
    private SnifferState state = null;

    public SnifferTrait() {
        super("sniffertrait");
    }

    public SnifferState getState() {
        return this.state;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !(this.npc.getCosmeticEntity() instanceof Sniffer)) {
            return;
        }
        NMS.setSnifferState(this.npc.getCosmeticEntity(), this.state);
    }

    public void setState(SnifferState state) {
        this.state = state;
    }

    @Command(aliases={"npc"}, usage="sniffer (--state [state])", desc="", modifiers={"sniffer"}, min=1, max=1, permission="citizens.npc.sniffer")
    @Requirements(selected=true, ownership=true, cosmeticTypes={EntityType.SNIFFER})
    public static void sniffer(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"state"}) SnifferState state) throws CommandException {
        SnifferTrait trait = npc.getOrAddTrait(SnifferTrait.class);
        String output = "";
        if (state != null) {
            trait.setState(state);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.sniffer.state-set", new Object[]{npc.getName(), state});
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }

    public static enum SnifferState {
        DIGGING,
        FEELING_HAPPY,
        IDLING,
        RISING,
        SCENTING,
        SEARCHING,
        SNIFFING;

    }
}

