/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistDelegate;
import net.citizensnpcs.api.util.DataKey;

public class PersistenceLoader {
    private static Map<Class<?>, Field[]> fieldCache = new WeakHashMap();
    private static Map<Class<? extends PersistDelegate>, PersistDelegate> loadedDelegates = new WeakHashMap<Class<? extends PersistDelegate>, PersistDelegate>();

    public static <T> T load(T instance, DataKey root) {
        Field[] fields;
        Class<?> clazz = instance.getClass();
        for (Field field : fields = PersistenceLoader.getFields(clazz)) {
            PersistenceLoader.deserialise(instance, field, root);
        }
        return instance;
    }

    private static void deserialise(Object instance, Field field, DataKey root) {
        Object value;
        if (List.class.isAssignableFrom(field.getType())) {
            PersistenceLoader.deserialiseList(instance, field, root);
            return;
        }
        Persist persistAnnotation = field.getAnnotation(Persist.class);
        String key = persistAnnotation.value().isEmpty() ? field.getName().toLowerCase() : persistAnnotation.value();
        PersistDelegate delegate = PersistenceLoader.getDelegate(field);
        Object object = value = delegate == null ? root.getRaw(key) : delegate.create(root);
        if (value == null) {
            return;
        }
        try {
            field.set(instance, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static PersistDelegate getDelegate(Field field) {
        DelegatePersistence delegate = field.getAnnotation(DelegatePersistence.class);
        if (delegate == null) {
            return null;
        }
        return loadedDelegates.get(delegate);
    }

    private static void deserialiseList(Object instance, Field field, DataKey root) {
        ArrayList list = Lists.newArrayList();
        Persist persistAnnotation = field.getAnnotation(Persist.class);
        String key = persistAnnotation.value().isEmpty() ? field.getName().toLowerCase() : persistAnnotation.value();
        PersistDelegate delegate = PersistenceLoader.getDelegate(field);
        for (DataKey subKey : root.getRelative(key).getSubKeys()) {
            Object value;
            Object object = value = delegate == null ? subKey.getRaw("") : delegate.create(subKey);
            if (value == null) continue;
            list.add(value);
        }
        try {
            field.set(instance, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Field[] getFields(Class<?> clazz) {
        Field[] fields = fieldCache.get(clazz);
        if (fields == null) {
            fields = PersistenceLoader.getFieldsFromClass(clazz);
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private static Field[] getFieldsFromClass(Class<?> clazz) {
        ArrayList toFilter = Lists.newArrayList((Object[])clazz.getDeclaredFields());
        Iterator itr = toFilter.iterator();
        while (itr.hasNext()) {
            PersistDelegate in;
            Field field = (Field)itr.next();
            Persist persistAnnotation = field.getAnnotation(Persist.class);
            if (persistAnnotation == null) {
                itr.remove();
                continue;
            }
            DelegatePersistence delegate = field.getAnnotation(DelegatePersistence.class);
            if (delegate == null) continue;
            Class<? extends PersistDelegate> delegateClass = delegate.value();
            if (!loadedDelegates.containsKey(delegateClass)) {
                try {
                    loadedDelegates.put(delegateClass, delegateClass.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    loadedDelegates.put(delegateClass, null);
                }
            }
            if ((in = loadedDelegates.get(delegateClass)) != null) continue;
            itr.remove();
        }
        return toFilter.toArray(new Field[toFilter.size()]);
    }

    public static <T> T load(Class<? extends T> clazz, DataKey root) {
        try {
            return PersistenceLoader.load(clazz.newInstance(), root);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void save(Object save, DataKey root) {
    }
}

