/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.goals.WanderGoal;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.EntityMarkers;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class WanderWaypointProvider
implements WaypointProvider {
    private WanderGoal currentGoal;
    @Persist
    private int delay = -1;
    private NPC npc;
    @Persist
    private boolean pathfind = true;
    private boolean paused;
    @Persist
    private final List<Location> regionCentres = Lists.newArrayList();
    private PhTreeSolid<Boolean> tree = PhTreeSolid.create((int)3);
    @Persist
    private String worldguardRegion;
    private Object worldguardRegionCache;
    @Persist
    private int xrange = 25;
    @Persist
    private int yrange = 3;

    public void addRegionCentre(Location centre) {
        this.regionCentres.add(centre);
        this.recalculateTree();
    }

    public void addRegionCentres(Collection<Location> centre) {
        this.regionCentres.addAll(centre);
        this.recalculateTree();
    }

    @Override
    public WaypointEditor createEditor(final CommandSender sender, CommandContext args) {
        return new WaypointEditor(){
            boolean editingRegions = false;
            EntityMarkers<Location> markers = new EntityMarkers();

            @Override
            public void begin() {
                Messaging.sendTr(sender, "citizens.editors.waypoints.wander.begin", WanderWaypointProvider.this.pathfind ? "<green>" : "<red>");
                WanderWaypointProvider.this.setPaused(true);
            }

            @Override
            public void end() {
                Messaging.sendTr(sender, "citizens.editors.waypoints.wander.end", new Object[0]);
                this.editingRegions = false;
                WanderWaypointProvider.this.setPaused(false);
                this.markers.destroyMarkers();
            }

            private String formatLoc(Location location) {
                return String.format("[[%d]], [[%d]], [[%d]]", location.getBlockX(), location.getBlockY(), location.getBlockZ());
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                if (!event.getPlayer().equals((Object)sender)) {
                    return;
                }
                String message = event.getMessage().toLowerCase();
                if (message.startsWith("xrange") || message.startsWith("yrange")) {
                    event.setCancelled(true);
                    int range = 0;
                    try {
                        range = Integer.parseInt(message.split(" ", 2)[1]);
                        if (range <= 0) {
                            range = 0;
                        }
                        if (message.startsWith("xrange")) {
                            WanderWaypointProvider.this.setXYRange(range, WanderWaypointProvider.this.yrange);
                        } else {
                            WanderWaypointProvider.this.setXYRange(WanderWaypointProvider.this.xrange, range);
                        }
                        WanderWaypointProvider.this.recalculateTree();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> Messaging.sendTr(sender, "citizens.editors.waypoints.wander.range-set", WanderWaypointProvider.this.xrange, WanderWaypointProvider.this.yrange));
                } else if (message.startsWith("regions")) {
                    event.setCancelled(true);
                    this.editingRegions = !this.editingRegions;
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        if (this.editingRegions) {
                            for (Location regionCentre : WanderWaypointProvider.this.regionCentres) {
                                Entity entity = this.markers.createMarker(regionCentre, regionCentre);
                                entity.setMetadata("wandermarker", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)regionCentre));
                            }
                            Messaging.sendTr(sender, "citizens.editors.waypoints.wander.editing-regions", new Object[0]);
                        } else {
                            this.markers.destroyMarkers();
                            Messaging.sendTr(sender, "citizens.editors.waypoints.wander.editing-regions-stop", new Object[0]);
                        }
                    });
                } else if (message.startsWith("delay")) {
                    event.setCancelled(true);
                    WanderWaypointProvider.this.setDelay(Util.parseTicks(message.split(" ")[1]));
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> Messaging.sendTr(sender, "citizens.editors.waypoints.wander.delay-set", WanderWaypointProvider.this.delay));
                } else if (message.startsWith("worldguardregion")) {
                    event.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        ProtectedRegion region = null;
                        String regionId = message.replace("worldguardregion", "").trim();
                        try {
                            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)WanderWaypointProvider.this.npc.getStoredLocation().getWorld()));
                            region = manager.getRegion(regionId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (region == null) {
                            Messaging.sendErrorTr(sender, "citizens.editors.waypoints.wander.worldguard-region-not-found", new Object[0]);
                            return;
                        }
                        WanderWaypointProvider.this.setWorldGuardRegion(regionId);
                        Messaging.sendErrorTr(sender, "citizens.editors.waypoints.wander.worldguard-region-set", regionId);
                    });
                } else if (message.startsWith("pathfind")) {
                    event.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        WanderWaypointProvider.this.pathfind = !WanderWaypointProvider.this.pathfind;
                        if (WanderWaypointProvider.this.currentGoal != null) {
                            WanderWaypointProvider.this.currentGoal.setPathfind(WanderWaypointProvider.this.pathfind);
                        }
                        this.begin();
                    });
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteract(PlayerInteractEvent event) {
                if (!event.getPlayer().equals((Object)sender) || event.getAction() == Action.PHYSICAL || !WanderWaypointProvider.this.npc.isSpawned() || !this.editingRegions || event.getPlayer().getWorld() != WanderWaypointProvider.this.npc.getEntity().getWorld() || Util.isOffHand(event)) {
                    return;
                }
                if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_AIR) {
                    if (event.getClickedBlock() == null) {
                        return;
                    }
                    event.setCancelled(true);
                    Location at = event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0);
                    if (!WanderWaypointProvider.this.regionCentres.contains(at)) {
                        WanderWaypointProvider.this.regionCentres.add(at);
                        Entity entity = this.markers.createMarker(at, at);
                        entity.setMetadata("wandermarker", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)at));
                        Messaging.sendTr(sender, "citizens.editors.waypoints.wander.added-region", this.formatLoc(at), WanderWaypointProvider.this.regionCentres.size());
                        WanderWaypointProvider.this.recalculateTree();
                    }
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
                if (!sender.equals((Object)event.getPlayer()) || !this.editingRegions || Util.isOffHand(event) || !event.getRightClicked().hasMetadata("wandermarker")) {
                    return;
                }
                WanderWaypointProvider.this.regionCentres.remove(((MetadataValue)event.getRightClicked().getMetadata("wandermarker").get(0)).value());
                this.markers.removeMarker((Location)((MetadataValue)event.getRightClicked().getMetadata("wandermarker").get(0)).value());
                Messaging.sendTr(sender, "citizens.editors.waypoints.wander.removed-region", this.formatLoc((Location)((MetadataValue)event.getRightClicked().getMetadata("wandermarker").get(0)).value()), WanderWaypointProvider.this.regionCentres.size());
                WanderWaypointProvider.this.recalculateTree();
            }
        };
    }

    public int getDelay() {
        return this.delay;
    }

    public List<Location> getRegionCentres() {
        return new RecalculateList();
    }

    public Object getWorldGuardRegion() {
        if (this.worldguardRegion == null) {
            return null;
        }
        if (this.worldguardRegionCache != null) {
            return this.worldguardRegionCache;
        }
        try {
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)this.npc.getStoredLocation().getWorld()));
            this.worldguardRegionCache = manager.getRegion(this.worldguardRegion);
            return this.worldguardRegionCache;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public int getXRange() {
        return this.xrange;
    }

    public int getYRange() {
        return this.yrange;
    }

    public boolean isPathfind() {
        return this.pathfind;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void load(DataKey key) {
        this.recalculateTree();
    }

    @Override
    public void onRemove() {
        this.worldguardRegionCache = null;
        if (this.currentGoal == null) {
            return;
        }
        this.currentGoal.pause();
        this.npc.getDefaultGoalController().removeGoal(this.currentGoal);
        this.currentGoal = null;
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = WanderGoal.builder(npc).xrange(this.xrange).yrange(this.yrange).pathfind(this.pathfind).tree(() -> this.regionCentres.isEmpty() ? null : this.tree).delay(this.delay).worldguardRegion(this::getWorldGuardRegion).build();
            if (this.paused) {
                this.currentGoal.pause();
            }
        } else {
            npc.getDefaultGoalController().removeGoal(this.currentGoal);
        }
        npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
    }

    private void recalculateTree() {
        this.tree = PhTreeSolid.create((int)3);
        for (Location loc : this.regionCentres) {
            long[] lower = new long[]{loc.getBlockX() - this.xrange, loc.getBlockY() - this.yrange, loc.getBlockZ() - this.xrange};
            long[] upper = new long[]{loc.getBlockX() + this.xrange, loc.getBlockY() + this.yrange, loc.getBlockZ() + this.xrange};
            this.tree.put(lower, upper, (Object)true);
        }
    }

    public void removeRegionCentre(Location centre) {
        this.regionCentres.remove(centre);
        this.recalculateTree();
    }

    public void removeRegionCentres(Collection<Location> centre) {
        this.regionCentres.removeAll(centre);
        this.recalculateTree();
    }

    @Override
    public void save(DataKey key) {
    }

    public void setDelay(int delay) {
        this.delay = delay;
        if (this.currentGoal != null) {
            this.currentGoal.setDelay(delay);
        }
    }

    public void setPathfind(boolean pathfind) {
        this.pathfind = pathfind;
        if (this.currentGoal != null) {
            this.currentGoal.setPathfind(pathfind);
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
        if (this.currentGoal != null) {
            if (paused) {
                this.currentGoal.pause();
            } else {
                this.currentGoal.unpause();
            }
        }
    }

    public void setWorldGuardRegion(String region) {
        this.worldguardRegion = region;
        this.worldguardRegionCache = null;
    }

    public void setXYRange(int xrange, int yrange) {
        this.xrange = xrange;
        this.yrange = yrange;
        if (this.currentGoal != null) {
            this.currentGoal.setXYRange(xrange, yrange);
        }
    }

    private class RecalculateList
    extends ForwardingList<Location> {
        private RecalculateList() {
        }

        public void add(int idx, Location loc) {
            super.add(idx, (Object)loc);
            WanderWaypointProvider.this.recalculateTree();
        }

        public boolean add(Location loc) {
            boolean val = super.add((Object)loc);
            WanderWaypointProvider.this.recalculateTree();
            return val;
        }

        protected List<Location> delegate() {
            return WanderWaypointProvider.this.regionCentres;
        }

        public Location remove(int idx) {
            Location val = (Location)super.remove(idx);
            WanderWaypointProvider.this.recalculateTree();
            return val;
        }

        public Location set(int idx, Location idx2) {
            Location val = (Location)super.set(idx, (Object)idx2);
            WanderWaypointProvider.this.recalculateTree();
            return val;
        }
    }
}

