/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTree;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.waypoint.EntityMarkers;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class GuidedWaypointProvider
implements WaypointProvider.EnumerableWaypointProvider {
    private GuidedAIGoal currentGoal;
    private final List<Waypoint> destinations = Lists.newArrayList();
    private float distance = -1.0f;
    private final List<Waypoint> guides = Lists.newArrayList();
    private NPC npc;
    private boolean paused;
    private final PhTree<Waypoint> tree = PhTree.create((int)3);
    private final PhTree<Waypoint> treePlusDestinations = PhTree.create((int)3);
    private static final AStarMachine<GuidedNode, GuidedPlan> ASTAR = AStarMachine.createWithDefaultStorage();

    public void addDestination(Waypoint waypoint) {
        this.destinations.add(waypoint);
        this.rebuildTree();
    }

    public void addDestinations(Collection<Waypoint> waypoint) {
        this.destinations.addAll(waypoint);
        this.rebuildTree();
    }

    public void addGuide(Waypoint helper) {
        this.guides.add(helper);
        this.rebuildTree();
    }

    public void addGuides(Collection<Waypoint> helper) {
        this.guides.addAll(helper);
        this.rebuildTree();
    }

    @Override
    public WaypointEditor createEditor(final CommandSender sender, CommandContext args) {
        if (!(sender instanceof Player)) {
            Messaging.sendErrorTr(sender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
            return null;
        }
        final Player player = (Player)sender;
        return new WaypointEditor(){
            private final EntityMarkers<Waypoint> markers = new EntityMarkers();
            private boolean showPath = true;

            @Override
            public void begin() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.begin", new Object[0]);
                if (this.showPath) {
                    this.createWaypointMarkers();
                }
            }

            private void createDestinationMarker(Waypoint element) {
                NPC npc = this.createMarker(element);
                if (npc != null) {
                    npc.data().set(NPC.Metadata.GLOWING, (Object)true);
                }
            }

            private NPC createMarker(Waypoint waypoint) {
                Entity entity = this.markers.createMarker(waypoint, waypoint.getLocation().clone().add(0.0, 1.0, 0.0));
                if (entity == null) {
                    return null;
                }
                NPC npc2 = ((NPCHolder)entity).getNPC();
                npc2.data().setPersistent("waypointhashcode", (Object)waypoint.hashCode());
                return ((NPCHolder)entity).getNPC();
            }

            private void createWaypointMarkers() {
                for (Waypoint waypoint : GuidedWaypointProvider.this.guides) {
                    this.createMarker(waypoint);
                }
                for (Waypoint waypoint : GuidedWaypointProvider.this.destinations) {
                    this.createDestinationMarker(waypoint);
                }
            }

            @Override
            public void end() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.end", new Object[0]);
                this.markers.destroyMarkers();
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                if (!event.getPlayer().equals((Object)sender)) {
                    return;
                }
                if (event.getMessage().equalsIgnoreCase("toggle path")) {
                    event.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), this::togglePath);
                } else if (event.getMessage().equalsIgnoreCase("clear")) {
                    event.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        GuidedWaypointProvider.this.destinations.clear();
                        GuidedWaypointProvider.this.guides.clear();
                        if (this.showPath) {
                            this.markers.destroyMarkers();
                        }
                    });
                } else if (event.getMessage().startsWith("distance ")) {
                    event.setCancelled(true);
                    double d = Double.parseDouble(event.getMessage().replace("distance ", "").trim());
                    if (d <= 0.0) {
                        return;
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        GuidedWaypointProvider.this.distance = (float)d;
                        Messaging.sendTr(sender, "citizens.editors.waypoints.guided.distance-set", d);
                    });
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteract(PlayerInteractEvent event) {
                if (!event.getPlayer().equals((Object)player) || event.getAction() == Action.PHYSICAL || event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null || Util.isOffHand(event)) {
                    return;
                }
                if (event.getPlayer().getWorld() != GuidedWaypointProvider.this.npc.getEntity().getWorld()) {
                    return;
                }
                event.setCancelled(true);
                Location at = event.getClickedBlock().getLocation();
                for (Waypoint waypoint : GuidedWaypointProvider.this.waypoints()) {
                    if (!waypoint.getLocation().equals((Object)at)) continue;
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.already-taken", new Object[0]);
                    return;
                }
                Waypoint element = new Waypoint(at);
                if (player.isSneaking()) {
                    GuidedWaypointProvider.this.destinations.add(element);
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.added-available", new Object[0]);
                } else {
                    GuidedWaypointProvider.this.guides.add(element);
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.added-guide", new Object[0]);
                }
                if (this.showPath) {
                    if (player.isSneaking()) {
                        this.createDestinationMarker(element);
                    } else {
                        this.createMarker(element);
                    }
                }
                GuidedWaypointProvider.this.rebuildTree();
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
                NPC clicked = CitizensAPI.getNPCRegistry().getNPC(event.getRightClicked());
                if (clicked == null || Util.isOffHand(event)) {
                    return;
                }
                Integer hashcode = (Integer)clicked.data().get("waypointhashcode");
                if (hashcode == null) {
                    return;
                }
                Iterator<Waypoint> itr = GuidedWaypointProvider.this.waypoints().iterator();
                while (itr.hasNext()) {
                    Waypoint point = itr.next();
                    if (point.hashCode() != hashcode.intValue()) continue;
                    this.markers.removeMarker(point);
                    itr.remove();
                    break;
                }
            }

            private void togglePath() {
                boolean bl = this.showPath = !this.showPath;
                if (this.showPath) {
                    this.createWaypointMarkers();
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.linear.showing-markers", new Object[0]);
                } else {
                    this.markers.destroyMarkers();
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.linear.not-showing-markers", new Object[0]);
                }
            }
        };
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void load(DataKey key) {
        DataKey dd = key.keyExists("availablewaypoints") ? key.getRelative("availablewaypoints") : key.getRelative("destinations");
        for (DataKey root : dd.getIntegerSubKeys()) {
            Waypoint waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, root));
            if (waypoint == null) continue;
            this.destinations.add(waypoint);
        }
        DataKey gd = key.keyExists("helperwaypoints") ? key.getRelative("helperwaypoints") : key.getRelative("guides");
        for (DataKey root : gd.getIntegerSubKeys()) {
            Waypoint waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, root));
            if (waypoint == null) continue;
            this.guides.add(waypoint);
        }
        if (key.keyExists("distance")) {
            this.distance = (float)key.getDouble("distance");
        }
        this.rebuildTree();
    }

    @Override
    public void onRemove() {
        if (this.currentGoal == null) {
            return;
        }
        this.currentGoal.onProviderChanged();
        this.npc.getDefaultGoalController().removeGoal(this.currentGoal);
        this.currentGoal = null;
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = new GuidedAIGoal();
            npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
        }
    }

    private void rebuildTree() {
        Location location;
        this.tree.clear();
        this.treePlusDestinations.clear();
        for (Waypoint waypoint : this.guides) {
            location = waypoint.getLocation();
            this.tree.put(new long[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()}, (Object)waypoint);
            this.treePlusDestinations.put(new long[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()}, (Object)waypoint);
        }
        for (Waypoint waypoint : this.destinations) {
            location = waypoint.getLocation();
            this.treePlusDestinations.put(new long[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()}, (Object)waypoint);
        }
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    @Override
    public void save(DataKey key) {
        int i;
        key.removeKey("availablewaypoints");
        DataKey root = key.getRelative("destinations");
        for (i = 0; i < this.destinations.size(); ++i) {
            PersistenceLoader.save(this.destinations.get(i), root.getRelative(i));
        }
        key.removeKey("helperwaypoints");
        root = key.getRelative("guides");
        for (i = 0; i < this.guides.size(); ++i) {
            PersistenceLoader.save(this.guides.get(i), root.getRelative(i));
        }
        if (this.distance != -1.0f) {
            key.setDouble("distance", this.distance);
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    @Override
    public Iterable<Waypoint> waypoints() {
        return Iterables.concat(this.destinations, this.guides);
    }

    private class GuidedAIGoal
    implements Goal {
        private GuidedPlan plan;
        private Waypoint target;

        private GuidedAIGoal() {
        }

        public void onProviderChanged() {
            if (this.plan == null) {
                return;
            }
            this.reset();
            if (GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                GuidedWaypointProvider.this.npc.getNavigator().cancelNavigation();
            }
        }

        @Override
        public void reset() {
            this.plan = null;
            this.target = null;
        }

        @Override
        public void run(GoalSelector selector) {
            if (this.plan != null && this.plan.isComplete()) {
                this.target.onReach(GuidedWaypointProvider.this.npc);
                this.plan = null;
            }
            if (this.plan == null) {
                selector.finish();
                return;
            }
            if (GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return;
            }
            Waypoint current = this.plan.getCurrentWaypoint();
            GuidedWaypointProvider.this.npc.getNavigator().setTarget(Util.getCenterLocation(current.getLocation().getBlock()));
            GuidedWaypointProvider.this.npc.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                if (this.plan != null) {
                    this.plan.update(GuidedWaypointProvider.this.npc);
                }
            });
        }

        @Override
        public boolean shouldExecute(GoalSelector selector) {
            if (GuidedWaypointProvider.this.paused || GuidedWaypointProvider.this.destinations.size() == 0 || !GuidedWaypointProvider.this.npc.isSpawned() || GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return false;
            }
            this.target = (Waypoint)GuidedWaypointProvider.this.destinations.get(Util.getFastRandom().nextInt(GuidedWaypointProvider.this.destinations.size()));
            if (!this.target.getLocation().getWorld().equals((Object)GuidedWaypointProvider.this.npc.getEntity().getWorld())) {
                this.target = null;
                return false;
            }
            this.plan = (GuidedPlan)ASTAR.runFully(new GuidedGoal(this.target), new GuidedNode(null, new Waypoint(GuidedWaypointProvider.this.npc.getStoredLocation())));
            return this.plan != null;
        }
    }

    private static class GuidedPlan
    implements Plan {
        private int index = 0;
        private final Waypoint[] path;

        public GuidedPlan(Iterable<GuidedNode> path) {
            this.path = (Waypoint[])Iterables.toArray((Iterable)Iterables.transform(path, to -> ((GuidedNode)to).waypoint), Waypoint.class);
        }

        public Waypoint getCurrentWaypoint() {
            return this.path[this.index];
        }

        @Override
        public boolean isComplete() {
            return this.index >= this.path.length;
        }

        @Override
        public void update(Agent agent) {
            ++this.index;
        }
    }

    private class GuidedNode
    extends AStarNode {
        private final Waypoint waypoint;

        public GuidedNode(GuidedNode parent, Waypoint waypoint) {
            super(parent);
            this.waypoint = waypoint;
        }

        @Override
        public Plan buildPlan() {
            return new GuidedPlan(this.orderedPath());
        }

        public double distance(Waypoint dest) {
            return this.waypoint.distance(dest);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GuidedNode other = (GuidedNode)obj;
            return Objects.equals(this.waypoint, other.waypoint);
        }

        @Override
        public Iterable<AStarNode> getNeighbours() {
            PhTree source = this.getParent() == null ? GuidedWaypointProvider.this.tree : GuidedWaypointProvider.this.treePlusDestinations;
            PhRangeQuery query = source.rangeQuery(GuidedWaypointProvider.this.distance == -1.0f ? (double)GuidedWaypointProvider.this.npc.getNavigator().getDefaultParameters().range() : (double)GuidedWaypointProvider.this.distance, new long[]{this.waypoint.getLocation().getBlockX(), this.waypoint.getLocation().getBlockY(), this.waypoint.getLocation().getBlockZ()});
            ArrayList neighbours = Lists.newArrayList();
            query.forEachRemaining(wp -> neighbours.add(new GuidedNode(this, (Waypoint)wp)));
            return neighbours;
        }

        @Override
        public int hashCode() {
            return 31 + (this.waypoint == null ? 0 : this.waypoint.hashCode());
        }

        public String toString() {
            return "GuidedNode [" + this.waypoint + "]";
        }
    }

    private static class GuidedGoal
    implements AStarGoal<GuidedNode> {
        private final Waypoint dest;

        public GuidedGoal(Waypoint dest) {
            this.dest = dest;
        }

        @Override
        public float g(GuidedNode from, GuidedNode to) {
            return (float)from.distance(to.waypoint);
        }

        @Override
        public float getInitialCost(GuidedNode node) {
            return this.h(node);
        }

        @Override
        public float h(GuidedNode from) {
            return (float)from.distance(this.dest);
        }

        @Override
        public boolean isFinished(GuidedNode node) {
            return node.waypoint.equals(this.dest);
        }
    }
}

