/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.EntityType;

@TraitName(value="chickentrait")
public class ChickenTrait
extends Trait {
    @Persist
    private Chicken.Variant variant;

    public ChickenTrait() {
        super("chickentrait");
    }

    public Chicken.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void run() {
        if (this.variant != null && this.npc.getEntity() instanceof Chicken) {
            Chicken chicken = (Chicken)this.npc.getEntity();
            chicken.setVariant(this.variant);
        }
    }

    public void setVariant(Chicken.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="chicken (--variant variant)", desc="", modifiers={"chicken"}, min=1, max=1, permission="citizens.npc.chicken")
    @Requirements(selected=true, ownership=true, types={EntityType.CHICKEN})
    public static void pig(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"variant"}) Chicken.Variant variant) throws CommandException {
        ChickenTrait trait = npc.getOrAddTrait(ChickenTrait.class);
        String output = "";
        if (args.hasValueFlag("variant")) {
            if (variant == null) {
                throw new CommandException("citizens.commands.npc.pig.invalid-variant", Util.listValuesPretty(Chicken.Variant.class));
            }
            trait.setVariant(variant);
            output = output + Messaging.tr("citizens.commands.npc.pig.variant-set", variant);
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }
}

